% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrib_diff.R
\name{distrib_diff_mahalanobis}
\alias{distrib_diff_mahalanobis}
\title{Compute the dissimilarity for a single multivariate Gaussian
distribution.}
\usage{
distrib_diff_mahalanobis(x, z_g, mu_g, sigma_g, logdet_g)
}
\arguments{
\item{x}{Data.}

\item{z_g}{Assignment probability vector for component g.}

\item{mu_g}{Mean vector for component g.}

\item{sigma_g}{Covariance matrix for component g.}

\item{logdet_g}{Log-determinants of covariance matrix for component g.}
}
\value{
\code{distrib_diff_mahalanobis} returns a list with the following elements:
\describe{
\item{\code{diff}}{Dissimilarity value for this component.}
\item{\code{dens}}{Gaussian density of all observations for this component.}
\item{\code{mahalas}}{Scaled squared sample Mahalanobis distances for all
observations with respect to this component.}
}
}
\description{
Compute the dissimilarity value and observation densities for a single
multivariate Gaussian distribution. This could be a whole component in a
Gaussian mixture model or the covariate part of a component in a Linear CWM.
}
