% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url_check.R
\name{check_urls}
\alias{check_urls}
\title{Check URLs of all md,rmd,and qmd files}
\usage{
check_urls(
  path = ".",
  output_dir = "check_reports",
  resources_dir = "resources",
  report_all = FALSE
)
}
\arguments{
\item{path}{path to the bookdown or quarto course repository, must have a
`.github` folder which will be used to establish the top of the repo.}

\item{output_dir}{A relative file path to the folder (existing or not) that the
output check file should be saved to. Default is "check_reports"}

\item{resources_dir}{A relative file path to the folder (existing or not) that the
ignore_urls.txt file and exclude_files.txt will be found. Default is "resources".
If no ignore_urls.txt file and exclude_files.txt files are found, we will download one.}

\item{report_all}{Should all URLs that were tested be returned? Default is FALSE
meaning only broken URLs will be reported in the url_checks.tsv file.}
}
\value{
A file will be saved that lists the broken URLs will be saved to the specified output_dir.
}
\description{
Check URLs of all md,rmd,and qmd files
}
\examples{
\dontrun{

rmd_dir <- setup_ottr_template(dir = ".", type = "rmd", render = FALSE)

check_urls(rmd_dir)

# If there are broken URLs they will be printed in a list at "check_reports/url_checks.tsv"

qmd_dir <- setup_ottr_template(dir = ".", type = "quarto", render = FALSE)

check_urls(qmd_dir)
}
}
