% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_user_blocks.R
\name{osm_create_user_block}
\alias{osm_create_user_block}
\title{Create a user block}
\usage{
osm_create_user_block(
  user_id,
  reason,
  period,
  needs_view = FALSE,
  format = c("R", "xml", "json")
)
}
\arguments{
\item{user_id}{Blocked user id.}

\item{reason}{Reason for block shown to the blocked user (markdown text).}

\item{period}{Block duration in hours between 0 and maximum block period, currently 87660.}

\item{needs_view}{If \code{TRUE}, the user is required to view the block page for the block to be lifted.
Default to \code{FALSE}.}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"xml"}, or \code{"json"}.}
}
\value{
Same format as \code{\link[=osm_get_user_blocks]{osm_get_user_blocks()}}
}
\description{
Create a user block
}
\examples{
\dontrun{
set_osmapi_connection("testing") # use the testing server

my_user_id <- osm_details_logged_user()$user["id"]
osm_create_user_block(user_id = my_user_id, reason = "Not really evil, just testing.", period = 0)
}
}
\seealso{
Other user blocks' functions: 
\code{\link{osm_get_user_blocks}()},
\code{\link{osm_list_active_user_blocks}()}

Other functions for moderators: 
\code{\link{osm_delete_note}()},
\code{\link{osm_hide_comment_changeset_discussion}()},
\code{\link{osm_redaction_object}()}
}
\concept{functions for moderators}
\concept{user blocks' functions}
