% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexing.R
\name{bng_to_xy}
\alias{bng_to_xy}
\alias{xy_to_bng}
\alias{xy_to_bng.numeric}
\alias{xy_to_bng.matrix}
\alias{xy_to_bng.data.frame}
\title{Convert BNG References}
\usage{
bng_to_xy(
  bng_ref,
  position = c("lower-left", "upper-left", "upper-right", "lower-right", "centre"),
  ...
)

xy_to_bng(...)

\method{xy_to_bng}{numeric}(easting, northing, resolution, ...)

\method{xy_to_bng}{matrix}(x, resolution, ...)

\method{xy_to_bng}{data.frame}(df, cols = c("eastings", "northings"), resolution, ...)
}
\arguments{
\item{bng_ref}{vector of type \code{BNGReference} objects}

\item{position}{character indicating which point location of the BNG grid
square is returned. Default is the lower-left corner.}

\item{...}{additional parameters, not currently used}

\item{easting}{numeric vector of coordinates}

\item{northing}{numeric vector of coordinates}

\item{resolution}{target BNG grid resolution. Can be specified as a numeric
or character vector}

\item{x}{two column matrix of eastings and northings}

\item{df}{data.frame with columns of coordinates to convert}

\item{cols}{column names or indices within \code{df} holding coordinates}
}
\value{
\itemize{
\item \code{xy_to_bng}: vector of \code{BNGReference} objects
\item \code{bng_to_xy}: two-column matrix of eastings and northings
}
}
\description{
Create British National Grid references from coordinates at a specific
resolution or convert grid reference objects to coordinates at a grid
position.
}
\details{
Coordinates must be in British National Grid projection (EPSG:27700) using
eastings and northings in meters. These functions do not support coordinate
transformations.
}
\examples{
bng_to_xy(as_bng_reference("SU"), "lower-left")

bng_to_xy(as_bng_reference("SU 3 1"), "lower-left")

bng_to_xy(as_bng_reference("SU 3 1 NE"), "centre")

bng_to_xy(as_bng_reference("SU 37289 15541"), "centre")

xy_to_bng(437289, 115541, "100km")

xy_to_bng(437289, 115541, "10km")

xy_to_bng(437289, 115541, "5km")

xy_to_bng(437289, 115541, 1)
  
}
