% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-affiliations.R
\name{orcid_services}
\alias{orcid_services}
\title{Retrieve services from ORCID}
\usage{
orcid_services(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{put_code}{Unique identifier for this service record}
\item{organization}{Name of the organization}
\item{department}{Department name (if available)}
\item{role}{Service role or title}
\item{start_date}{Service start date (ISO format)}
\item{end_date}{Service end date (ISO format)}
\item{city}{City of organization}
\item{region}{State/region of organization}
\item{country}{Country of organization}
}
Returns an empty data.table with the same structure if no service
records are found.
}
\description{
Fetches service activity records for an ORCID identifier, such as
committee memberships, editorial board positions, peer review activities, etc.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/services}
}
\examples{
\dontrun{
# Fetch services
services <- orcid_services("0000-0002-1825-0097")
print(services)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_peer_reviews}}, \code{\link{orcid_activities}}
}
