% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-affiliations.R
\name{orcid_qualifications}
\alias{orcid_qualifications}
\title{Retrieve qualifications from ORCID}
\usage{
orcid_qualifications(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{put_code}{Unique identifier for this qualification record}
\item{organization}{Name of the issuing organization}
\item{department}{Department name (if available)}
\item{role}{Qualification title}
\item{start_date}{Qualification date (ISO format)}
\item{end_date}{Expiration date (ISO format, if applicable)}
\item{city}{City of organization}
\item{region}{State/region of organization}
\item{country}{Country of organization}
}
Returns an empty data.table with the same structure if no qualification
records are found.
}
\description{
Fetches professional qualification records for an ORCID identifier, such as
licenses, certifications, etc.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/qualifications}
}
\examples{
\dontrun{
# Fetch qualifications
qualifications <- orcid_qualifications("0000-0002-1825-0097")
print(qualifications)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_educations}}, \code{\link{orcid_activities}}
}
