% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-person.R
\name{orcid_address}
\alias{orcid_address}
\title{Retrieve address information from ORCID}
\usage{
orcid_address(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{put_code}{Unique identifier for this address}
\item{country}{Country code}
}
Returns an empty data.table with the same structure if no address
information is found.
}
\description{
Fetches address/country information associated with an ORCID record.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/address}
}
\examples{
\dontrun{
# Fetch address information
address <- orcid_address("0000-0002-1825-0097")
print(address)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_person}}
}
