% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_cell_style}
\alias{wb_cell_style}
\alias{wb_get_cell_style}
\alias{wb_set_cell_style}
\alias{wb_set_cell_style_across}
\title{Get or set cell style indices}
\usage{
wb_get_cell_style(wb, sheet = current_sheet(), dims)

wb_set_cell_style(wb, sheet = current_sheet(), dims, style)

wb_set_cell_style_across(
  wb,
  sheet = current_sheet(),
  style,
  cols = NULL,
  rows = NULL
)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object.}

\item{sheet}{The name or index of the worksheet. Defaults to the current sheet.}

\item{dims}{A character string defining the cell range (e.g., "A1" or "A1:C10").}

\item{style}{A style or a cell with a certain style}

\item{cols}{The columns the style will be applied to, either "A:D" or 1:4}

\item{rows}{The rows the style will be applied to}
}
\value{
\itemize{
\item For \code{wb_get_cell_style()}: A named vector where names are cell addresses
(e.g., "A1") and values are the integer style indices.
\item For \code{wb_set_cell_style()}: The \link{wbWorkbook} object, invisibly.
}

A named vector with cell style index positions
}
\description{
The \code{wb_get_cell_style()} and \code{wb_set_cell_style()} functions provide a
direct way to manage the internal style index (XF ID) of a cell. This is
particularly useful for "copy-pasting" the formatting from one cell to
another or for applying pre-defined styles at scale without the overhead
of creating new XML nodes for every cell.
}
\details{
In the OpenXML format, formatting is not stored inside every cell. Instead,
a workbook maintains a centralized style table, and each cell simply holds
an integer index (the Cell Style ID) pointing to a record in that table.

\code{wb_get_cell_style()} retrieves these indices for a specified range. If
a cell has not been explicitly styled, the function returns the index for
the default style.

\code{wb_set_cell_style()} applies a specific index or style definition to a
range. This is significantly faster and more memory-efficient than using high-level
wrappers like \code{wb_add_font()} when applying the exact same style to thousands
of individual cells.
}
\section{Notes}{

\itemize{
\item These functions are the most efficient way to handle repetitive styling
tasks in large worksheets.
\item If \code{style} is a character string that is not a cell dimension, it is
looked up in the workbook's Style Manager.
}
}

\examples{
# set a style in B1
wb <- wb_workbook()$add_worksheet()$
  add_numfmt(dims = "B1", numfmt = "#,0")

# get style from B1 to assign it to A1
numfmt <- wb$get_cell_style(dims = "B1")

# assign style to a1
wb$set_cell_style(dims = "A1", style = numfmt)

# set style across a workbook
wb <- wb_workbook()
wb <- wb_add_worksheet(wb)
wb <- wb_add_fill(wb, dims = "C3", color = wb_color("yellow"))
wb <- wb_set_cell_style_across(wb, style = "C3", cols = "C:D", rows = 3:4)
}
\seealso{
Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_cell_style}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_font}()},
\code{\link{wb_add_named_style}()},
\code{\link{wb_add_numfmt}()}
}
\concept{styles}
