% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_font}
\alias{wb_add_font}
\title{Modify font properties in a cell region}
\usage{
wb_add_font(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  name = "Aptos Narrow",
  color = wb_color(hex = "FF000000"),
  size = "11",
  bold = "",
  italic = "",
  outline = "",
  strike = "",
  underline = "",
  charset = "",
  condense = "",
  extend = "",
  family = "",
  scheme = "",
  shadow = "",
  vert_align = "",
  update = FALSE,
  ...
)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object.}

\item{sheet}{The name or index of the worksheet. Defaults to the current sheet.}

\item{dims}{A character string defining the cell range (e.g., "A1:K1").}

\item{name}{Character; the font name. Defaults to "Aptos Narrow".}

\item{color}{A \code{\link[=wb_color]{wb_color()}} object or hex string defining the font color.
Defaults to black ("FF000000").}

\item{size}{Numeric; the font size. Defaults to 11.}

\item{bold}{Logical; applies bold formatting if \code{TRUE}.}

\item{italic}{Logical; applies italic formatting if \code{TRUE}.}

\item{outline}{Logical; applies an outline effect to the text.}

\item{strike}{Logical; applies a strikethrough effect.}

\item{underline}{Character; the underline style, such as "single" or "double".}

\item{charset}{Character; the character set ID. See \code{\link[=fmt_txt]{fmt_txt()}} for details.}

\item{condense}{Logical; whether the font should be condensed.}

\item{extend}{Logical; whether the font should be extended.}

\item{family}{Character; the font family index (e.g., "1" for Roman, "2" for Swiss).}

\item{scheme}{Character; the font scheme. One of "minor", "major", or "none".}

\item{shadow}{Logical; applies a shadow effect to the text.}

\item{vert_align}{Character; vertical alignment. Options are "baseline",
"superscript", or "subscript".}

\item{update}{Logical or character vector. Controls whether to overwrite
the entire font style or only update specific properties.}

\item{...}{Additional arguments.}
}
\value{
The \link{wbWorkbook} object, invisibly.

A \code{wbWorkbook}, invisibly
}
\description{
The \code{wb_add_font()} function provides granular control over the visual
appearance of text within a specified cell region. While other styling
functions include basic font options, \code{wb_add_font()} exposes the full range
of font attributes supported by the OpenXML specification, allowing for
precise adjustments to typeface, sizing, color, and emphasis.
}
\details{
This function operates on the font node of a cell's style. It is particularly
powerful when used with the \code{update} argument, which allows users to modify
specific attributes (like color) while preserving other existing font properties
(like bold or font name).

For common tasks, adjusting \code{name}, \code{size}, and \code{color} is sufficient.
However, the function also supports advanced properties like \code{vert_align}
(for subscripts/superscripts), \code{family} (font categories), and \code{scheme}
(theme-based font sets).

Note on Updates:
\itemize{
\item If \code{update = FALSE} (default), the function applies the new font
definition as a complete replacement for the existing font style.
\item If \code{update} is a character vector (e.g., \code{c("color", "size")}), only those
specific attributes are modified, and all other existing font properties
are retained.
\item Setting \code{update = NULL} removes the custom font style entirely, reverting
the cells to the workbook's default font.
}
}
\section{Notes}{

\itemize{
\item This function modifies the cell-level style and does not alter rich text
strings created with \code{\link[=fmt_txt]{fmt_txt()}}.
\item Font styles are pooled in the workbook's style manager to ensure efficiency
and XML compliance.
}
}

\examples{
 wb <- wb_workbook()
 wb <- wb_add_worksheet(wb, "S1")
 wb <- wb_add_data(wb, "S1", mtcars)
 wb <- wb_add_font(wb, "S1", "A1:K1", name = "Arial", color = wb_color(theme = "4"))
# With chaining
 wb <- wb_workbook()$add_worksheet("S1")$add_data("S1", mtcars)
 wb$add_font("S1", "A1:K1", name = "Arial", color = wb_color(theme = "4"))

# Update the font color
 wb$add_font("S1", "A1:K1", color = wb_color("orange"), update = c("color"))
}
\seealso{
Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_cell_style}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_named_style}()},
\code{\link{wb_add_numfmt}()},
\code{\link{wb_cell_style}}
}
\concept{styles}
