% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{ors_geocode}
\alias{ors_geocode}
\title{Openrouteservice Geocoding}
\usage{
ors_geocode(
  query,
  location,
  ...,
  api_key = ors_api_key(),
  output = c("parsed", "text", "sf")
)
}
\arguments{
\item{query}{Name of location, street address or postal code. For a
structured geocoding request a named list of parameters.}

\item{location}{Coordinates to be inquired provided in the form \code{c(longitude, latitude)}}

\item{...}{Optional parameters as described \href{https://openrouteservice.org/dev/#/api-docs/geocode}{here}}

\item{api_key}{Character scalar containing openrouteservice API key}

\item{output}{Output format. By default the response is being parsed to a list-based R object}
}
\value{
Geocoding: a JSON formatted list of objects corresponding to the
search input. Reverse geocoding: the next enclosing object with an address
tag which surrounds the given coordinate.
}
\description{
Resolve input coordinates to addresses and vice versa.
}
\details{
This endpoint can be used for geocoding (specified \code{query}) and reverse
geocoding requests (specified \code{location}). Either \code{query} or \code{location} has
to be specified for a valid request. If both parameters are specified
location takes precedence.
}
\examples{
# These examples might require interaction to query the local keyring, or
# might fail due to network issues, so they are not run by default
\dontrun{
## locations of Heidelberg around the globe
x <- ors_geocode("Heidelberg")

## set the number of results returned
x <- ors_geocode("Heidelberg", size = 1)

## search within a particular country
ors_geocode("Heidelberg", boundary.country = "DE")

## structured geocoding
x <- ors_geocode(list(locality="Heidelberg", county="Heidelberg"))

## reverse geocoding
location <- x$features[[1L]]$geometry$coordinates
y <- ors_geocode(location = location, layers = "locality", size = 1)
}
}
\author{
Andrzej Oleś \href{mailto:andrzej.oles@gmail.com}{andrzej.oles@gmail.com}
}
