% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importUKAQ.R
\name{importAURN}
\alias{importAURN}
\alias{importAQE}
\alias{importSAQN}
\alias{importWAQN}
\alias{importNI}
\alias{importLocal}
\title{Import data from individual UK Air Pollution Networks}
\usage{
importAURN(
  site = "my1",
  year = 2009,
  data_type = "hourly",
  pollutant = "all",
  hc = FALSE,
  meta = FALSE,
  meta_columns = c("site_type", "latitude", "longitude"),
  meteo = TRUE,
  ratified = FALSE,
  to_narrow = FALSE,
  verbose = FALSE,
  progress = TRUE
)

importAQE(
  site = "yk13",
  year = 2018,
  data_type = "hourly",
  pollutant = "all",
  meta = FALSE,
  meta_columns = c("site_type", "latitude", "longitude"),
  meteo = TRUE,
  ratified = FALSE,
  to_narrow = FALSE,
  verbose = FALSE,
  progress = TRUE
)

importSAQN(
  site = "gla4",
  year = 2009,
  data_type = "hourly",
  pollutant = "all",
  meta = FALSE,
  meta_columns = c("site_type", "latitude", "longitude"),
  meteo = TRUE,
  ratified = FALSE,
  to_narrow = FALSE,
  verbose = FALSE,
  progress = TRUE
)

importWAQN(
  site = "card",
  year = 2018,
  data_type = "hourly",
  pollutant = "all",
  meta = FALSE,
  meta_columns = c("site_type", "latitude", "longitude"),
  meteo = TRUE,
  ratified = FALSE,
  to_narrow = FALSE,
  verbose = FALSE,
  progress = TRUE
)

importNI(
  site = "bel0",
  year = 2018,
  data_type = "hourly",
  pollutant = "all",
  meta = FALSE,
  meta_columns = c("site_type", "latitude", "longitude"),
  meteo = TRUE,
  ratified = FALSE,
  to_narrow = FALSE,
  verbose = FALSE,
  progress = TRUE
)

importLocal(
  site = "ad1",
  year = 2018,
  data_type = "hourly",
  pollutant = "all",
  meta = FALSE,
  meta_columns = c("site_type", "latitude", "longitude"),
  to_narrow = FALSE,
  verbose = FALSE,
  progress = TRUE
)
}
\arguments{
\item{site}{Site code of the site to import, e.g., \code{"my1"} is Marylebone
Road. Site codes can be discovered through the use of \code{\link[=importMeta]{importMeta()}}.
Several sites can be imported at once. For example, \code{site = c("my1", "nott")} imports both Marylebone Road and Nottingham.}

\item{year}{Year(s) to import. To import a series of years use, e.g.,
\code{2000:2020}. To import several specific years use \code{year = c(2000, 2010, 2020)}.}

\item{data_type}{The type of data to be returned, defaulting to \code{"hourly"}
data. Alternative data types include:
\itemize{
\item \code{"daily"}: Daily average data.
\item \code{"monthly"}: Monthly average data with data capture information for the whole network.
\item \code{"annual"}: Annual average data with data capture information for the whole network.
\item \code{"15_min"}: 15-minute average SO2 concentrations.
\item \code{"8_hour"}: 8-hour rolling mean concentrations for O3 and CO.
\item \code{"24_hour"}: 24-hour rolling mean concentrations for particulates.
\item \code{"daily_max_8"}: Maximum daily rolling 8-hour maximum for O3 and CO.
\item \code{"daqi"}: Daily Air Quality Index (DAQI). See
\href{https://uk-air.defra.gov.uk/air-pollution/daqi?view=more-info}{here} for
more details of how the index is defined. Note that this \code{data_type} is not
available for locally managed monitoring networks.
}}

\item{pollutant}{Pollutants to import. If omitted will import all pollutants
from a site. To import only NOx and NO2 for example use \code{pollutant = c("nox", "no2")}. Pollutant names can be upper or lower case.}

\item{hc}{Include hydrocarbon measurements in the imported data? Defaults to
\code{FALSE} as most users will not be interested in using hydrocarbon data.}

\item{meta}{Append metadata columns to data for each selected \code{site}?
Defaults to \code{FALSE}. Columns are defined using \code{meta_columns}.}

\item{meta_columns}{The specific columns to append when \code{meta = TRUE}.
Defaults to site type, latitude and longitude. Can be any of \code{"site_type"},
\code{"latitude"}, \code{"longitude"}, \code{"zone"}, \code{"agglomeration"}, and
\code{"local_authority"} (as well as \code{"provider"} for locally managed data). See
\code{\link[=importMeta]{importMeta()}} for more complete information.}

\item{meteo}{Append modelled meteorological data, if available? Defaults to
\code{TRUE}, which will return wind speed (\code{ws}), wind direction (\code{wd}) and
ambient temperature (\code{air_temp}). The variables are calculated from using
the WRF model run by Ricardo Energy & Environment and are available for
most but not all networks. Setting \code{meteo = FALSE} is useful if you have
other meteorological data to use in preference, for example from the
\code{worldmet} package.}

\item{ratified}{Append \code{qc} column(s) to hourly data indicating whether each
species was ratified (i.e., quality-checked)?  Defaults to \code{FALSE}.}

\item{to_narrow}{Return the data in a "narrow"/"long"/"tidy" format? By
default the returned data is "wide" and has a column for each
pollutant/variable. When \code{to_narrow = TRUE} the data are returned with a
column identifying the pollutant name and a column containing the
corresponding concentration/statistic. Defaults to \code{FALSE}.}

\item{verbose}{Print messages to the console if hourly data cannot be
imported? Default is \code{FALSE}. \code{TRUE} is useful for debugging as the
specific \code{year}(s), \code{site}(s) and \code{source}(s) which cannot be imported will
be returned.}

\item{progress}{Show a progress bar when many sites/years are being imported?
Defaults to \code{TRUE}.}
}
\description{
These functions act as wrappers for \code{\link[=importUKAQ]{importUKAQ()}} to import air pollution
data from a range of UK networks including the Automatic Urban and Rural
Network (AURN), the individual England (AQE), Scotland (SAQN), Wales (WAQN)
and Northern Ireland (NI) Networks, and many "locally managed" monitoring
networks across England. While \code{\link[=importUKAQ]{importUKAQ()}} allows for data to be imported
more flexibly, including across multiple monitoring networks, these functions
are provided for convenience and back-compatibility.
}
\section{Importing UK Air Pollution Data}{


This family of functions has been written to make it easy to import data
from across several UK air quality networks. Ricardo have provided .RData
files (R workspaces) of all individual sites and years, as well as up to
date meta data. These files are updated on a daily basis. This approach
requires a link to the Internet to work.

There are several advantages over the web portal approach where .csv files
are downloaded.
\itemize{
\item First, it is quick to select a range of sites, pollutants
and periods (see examples below).
\item Second, storing the data as .RData
objects is very efficient as they are about four times smaller than .csv
files --- which means the data downloads quickly and saves bandwidth.
\item Third, the function completely avoids any need for data manipulation or
setting time formats, time zones etc. The function also has the advantage
that the proper site name is imported and used in
\link[=openair-package]{openair} functions.
}

Users should take care if using data from both \link[=openair-package]{openair}
\emph{and} web portals (for example, \href{https://uk-air.defra.gov.uk/data/}{UK AIR}). One key difference is that the
data provided by openair is date \emph{beginning}, whereas the web portal
provides date \emph{ending}. Hourly concentrations may therefore appear offset
by an hour, for example.

The data are imported by stacking sites on top of one another and will have
field names \code{site}, \code{code} (the site code) and \code{pollutant}.

By default, the function returns hourly average data. However, annual,
monthly, daily and 15 minute data (for SO2) can be returned using the
option \code{data_type}. Annual and monthly data provide whole network
information including data capture statistics.

All units are expressed in mass terms for gaseous species (ug/m3 for NO,
NO2, NOx (as NO2), SO2 and hydrocarbons; and mg/m3 for CO). PM10
concentrations are provided in gravimetric units of ug/m3 or scaled to be
comparable with these units. Over the years a variety of instruments have
been used to measure particulate matter and the technical issues of
measuring PM10 are complex. In recent years the measurements rely on FDMS
(Filter Dynamics Measurement System), which is able to measure the volatile
component of PM. In cases where the FDMS system is in use there will be a
separate volatile component recorded as 'v10' and non-volatile component
'nv10', which is already included in the absolute PM10 measurement. Prior
to the use of FDMS the measurements used TEOM (Tapered Element Oscillating.
Microbalance) and these concentrations have been multiplied by 1.3 to
provide an estimate of the total mass including the volatile fraction.

Some sites report hourly and daily PM10 and / or PM2.5. When \code{data_type = "daily"} and there are both hourly and 'proper' daily measurements
available, these will be returned as e.g. "pm2.5" and "gr_pm2.5"; the
former corresponding to data based on original hourly measurements and the
latter corresponding to daily gravimetric measurements.

The function returns modelled hourly values of wind speed (\code{ws}), wind
direction (\code{wd}) and ambient temperature (\code{air_temp}) if available
(generally from around 2010). These values are modelled using the WRF model
operated by Ricardo.

The BAM (Beta-Attenuation Monitor) instruments that have been incorporated
into the network throughout its history have been scaled by 1.3 if they
have a heated inlet (to account for loss of volatile particles) and 0.83 if
they do not have a heated inlet. The few TEOM instruments in the network
after 2008 have been scaled using VCM (Volatile Correction Model) values to
account for the loss of volatile particles. The object of all these scaling
processes is to provide a reasonable degree of comparison between data sets
and with the reference method and to produce a consistent data record over
the operational period of the network, however there may be some
discontinuity in the time series associated with instrument changes.

No corrections have been made to the PM2.5 data. The volatile component of
FDMS PM2.5 (where available) is shown in the 'v2.5' column.
}

\seealso{
Other import functions: 
\code{\link{importADMS}()},
\code{\link{importEurope}()},
\code{\link{importImperial}()},
\code{\link{importMeta}()},
\code{\link{importTraj}()},
\code{\link{importUKAQ}()}
}
\concept{import functions}
