% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_qtrap.R
\name{load_parse_sciex_txt}
\alias{load_parse_sciex_txt}
\title{Load and Parse SCIEX OS Exported LC-MRM-MS2 Data}
\usage{
load_parse_sciex_txt(
  file_path,
  input_data = NULL,
  return_all_columns = TRUE,
  check_negative_values = TRUE,
  fix_istds = TRUE
)
}
\arguments{
\item{file_path}{File path of the input text file of a complete output of the
SCIEX OS results from a sequence. File should be tab-delimited and in the
'long' format.}

\item{input_data}{Input tibble of raw SCIEX (pre-parsing) text file. If `NULL`
(default value), data will be loaded from `file_path`.}

\item{return_all_columns}{Logical value as to whether to return all columns (`TRUE`)
or just the necessary columns for downstream machine learning analysis or
quality control review (`FALSE`). Default value is `TRUE`.
When set to false, the columns included in the returned tibble include:
`"component_name"`, `"component_idx"`, `"precursor_mz"`, `"product_mz"`,
`"is_istd"`, `"istd"`, `"retention_time_expected"`, `"data_filename"`,
`"data_file_idx"`, `"sample_id"`, `"sample_type"`, `"component_type"`,
`"polarity"`, `"component_group"`, `"outlier_reasons"`,
`"retention_time_expected_istd"`, `"area"`, `"istd_area"`, `"area_ratio"`,
`"height"`, `"istd_height"`, `"height_ratio"`, `"peak_quality"`,
`"istd_peak_quality"`, `"retention_time"`, `"retention_time_istd"`,
`"rt_error"`, `"rt_delta_min"`, `"rt_start"`, `"istd_rt_start"`, `"rt_end"`,
`"istd_rt_end"`, `"peak_width"`, `"istd_peak_width"`, `"fwhm"`,
`"istd_fwhm"`, `"signal_noise"`, `"istd_signal_noise"`, `"modified"`,
`"relative_rt"`, `"used"`, `"tailing_factor"`, `"asymmetry_factor"`,
`points_across_baseline"`, `"points_across_fwhm"`).}

\item{check_negative_values}{Logical value as to whether to check for negative
values in the `area` and `height` variables (for both components and internal
standards). If `TRUE` (default) and there is at least one negative value in
the data, the minimum `area` or `height` value will be subtracted from all
`area` and/or `height` values by `component_name`, and 100 will then be added
to avoid having values below 100. `area_ratio`, `height_ratio`, and
`area_height_ratio` values (and their internal standard equivalent variables)
will also be re-calculated.}

\item{fix_istds}{Logical value (default `TRUE`) to identify internal standards
by regular expression of \code{"(\\.IS$)|(_IS$)|(_d[0-9]+_)|(\\(d[0-9]+\\))"}.}
}
\value{
tibble with the fields appropriately renamed.
}
\description{
Load and Parse SCIEX OS Exported LC-MRM-MS2 Data
}
\examples{
\dontrun{
data(sciex_mrm_ms_data)
data_tibble <- load_parse_sciex_txt(
  file_path = "path/to/file.txt",
  return_all_columns = FALSE,
  check_negative_values = TRUE
)
}
}
\author{
Yaoxiang Li
}
