% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_vt_smart.R
\name{search_vt_smart}
\alias{search_vt_smart}
\title{Search VecTraits using the explorer's filters}
\usage{
search_vt_smart(field, operator, value, basereq = vb_basereq())
}
\arguments{
\item{field}{a field of VecTraits to search.}

\item{operator}{an operator to use when searching.}

\item{value}{the value that the field might/might not be.}

\item{basereq}{an \link[httr2:request]{httr2 request} object, as generated by \code{\link[=vb_basereq]{vb_basereq()}}. If \code{NA}, uses the default request.}
}
\value{
An \code{ohvbd.ids} vector of VecTraits dataset IDs.
}
\description{
Retrieve the IDs for any VecTraits datasets matching the given filter.
}
\section{Valid fields}{

The following field names are valid (shortcut names are listed in brackets):
\itemize{
\item \code{DatasetID} (\emph{id})
\item \code{OriginalTraitName} (\emph{traitname})
\item \code{Variables}
\item \code{Interactor1Order} (\emph{order})
\item \code{Interactor1Family} (\emph{family})
\item \code{Interactor1Genus} (\emph{genus})
\item \code{Interactor1Species} (\emph{species, spp})
\item \code{Interactor1Stage} (\emph{stage})
\item \code{Interactor1Sex} (\emph{sex})
\item \code{Interactor2Genus} (\emph{genus2})
\item \code{Interactor2Species} (\emph{species2, spp2})
\item \code{Citation} (\emph{cite})
\item \code{DOI}
\item \code{CuratedByDOI} (\emph{curateddoi})
\item \code{SubmittedBy} (\emph{who})
\item \code{Tags}
}
}

\section{Valid operators}{

The following operators are valid (alternative names are listed in brackets):
\itemize{
\item \code{contains} (\emph{contain, has, have})
\item \code{!contains} (\emph{!contains, !has, !have, ncontains})
\item \code{equals} (\emph{=, ==, equal, eq})
\item \code{!equals} (\emph{!=, not, !equal, !eq, neq})
\item \code{starts} (\emph{starts with, start with, start, sw})
\item \code{!starts} (\emph{not starts with, not start with, !start, nsw})
\item \verb{in} (\emph{within})
\item \verb{!in} (\emph{not in, not within, !within, nin})
}
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
search_vt_smart("Interactor1Genus", "equals", "Anopheles")
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{vectraits}
