% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet.R
\name{glmnet_offset}
\alias{glmnet_offset}
\title{Fit Penalized Generalized Linear Models with an Offset}
\usage{
glmnet_offset(
  x,
  y,
  family,
  offset_col = "offset",
  weights = NULL,
  lambda = NULL,
  alpha = 1
)
}
\arguments{
\item{x}{Input matrix}

\item{y}{Response variable}

\item{family}{A function or character string describing the link function
and error distribution.}

\item{offset_col}{Character string. The name of a column in \code{data} containing
offsets.}

\item{weights}{Optional weights to use in the fitting process.}

\item{lambda}{A numeric vector of regularization penalty values}

\item{alpha}{A number between zero and one denoting the proportion of L1
(lasso) versus L2 (ridge) regularization.
\itemize{
\item \code{alpha = 1}: Pure lasso model
\item \code{alpha = 0}: Pure ridge model
}}
}
\value{
A \code{glmnet} object. See \code{\link[glmnet:glmnet]{glmnet::glmnet()}} for full details.
}
\description{
This function is a wrapper around \code{\link[glmnet:glmnet]{glmnet::glmnet()}} that uses a column from
\code{x} as an offset.
}
\details{
Outside of the \code{tidymodels} ecosystem, \code{glmnet_offset()} has no advantages
over \code{\link[glmnet:glmnet]{glmnet::glmnet()}} since that function allows for offsets to be
specified in its \code{offset} argument.

Within \code{tidymodels}, \code{glmnet_offset()} provides an advantage because it will
ensure that offsets are included in the data whenever resamples are created.

The \code{x}, \code{y}, \code{family}, \code{lambda}, \code{alpha} and \code{weights} arguments have the
same meanings as \code{\link[glmnet:glmnet]{glmnet::glmnet()}}. See that function's documentation for
full details.
}
\examples{
if (interactive()) {
  us_deaths$off <- log(us_deaths$population)
  x <- model.matrix(~ age_group + gender + off, us_deaths)[, -1]
  glmnet_offset(x, us_deaths$deaths, family = "poisson", offset_col = "off")
}

}
\seealso{
\code{\link[glmnet:glmnet]{glmnet::glmnet()}}
}
