% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_vector_at.R
\name{split_vector_at}
\alias{split_vector_at}
\title{Split a vector at positions}
\usage{
split_vector_at(x, at)
}
\arguments{
\item{x}{[atomic()`]\cr
A vector of elements.}

\item{at}{[\code{integer()}]\cr
Index position(s) just before to split.

For example, \code{at = n} splits before the \code{n}th element of \code{x}.}
}
\value{
A \code{list}.
}
\description{
This function splits a vector at specific positions.
}
\examples{
x <- 1:10
split_vector_at(x, c(2, 3, 5, 7))
}
\references{
Based on https://stackoverflow.com/a/19274414.
}
\seealso{
Other vector helpers: 
\code{\link{check_numeric_vector}()},
\code{\link{check_probability_vector}()},
\code{\link{chunk_vector}()},
\code{\link{equidistant_vectors}()},
\code{\link{insert_vector_entry}()},
\code{\link{map_indices}()},
\code{\link{match_numerics}()},
\code{\link{permutations}()},
\code{\link{subsets}()},
\code{\link{vector_occurrence}()}
}
\concept{vector helpers}
\keyword{transformation}
