# REQUEST

#' HAL API Endpoint
#'
#' @param path A [`character`] string giving the API name
#'  (defaults to "`search`").
#' @param instance A [`character`] string giving the HAL portal name.
#' @keywords internal
hal_endpoint <- function(path = c("search", "ref"), instance = NULL) {
  path <- match.arg(path)

  httr2::request("https://api.archives-ouvertes.fr") |>
    httr2::req_url_path_append(path) |>
    httr2::req_url_path_append(instance)
}

hal_is_error <- function(x) {
  length(httr2::resp_body_json(x)$error) > 0
}
hal_error_body <- function(x) {
  httr2::resp_body_json(x)$error$msg
}

#' HAL API
#'
#' Initialize a request to the HAL API.
#' @param query An object of class `HALQuery` (typically returned by
#'  [hal_query()]).
#' @inheritParams hal_endpoint
#' @return
#'  An HTTP request (a [`list`] of class `httr2_request`).
#' @keywords internal
hal_request <- function(query, path = "search", instance = NULL) {
  if (!inherits(query, "HALQuery")) stop("Wrong query!", call. = FALSE)

  hal_endpoint(path, instance) |>
    httr2::req_url_query(!!!query, .multi = "explode") |>
    httr2::req_error(is_error = hal_is_error, body = hal_error_body) |>
    httr2::req_user_agent("odyssey (http://nfrerebeau.codeberg.page/odyssey/)")
}
