% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odiffr-package.R
\docType{package}
\name{odiffr-package}
\alias{odiffr-package}
\alias{odiffr}
\title{Odiffr: Fast Pixel-by-Pixel Image Comparison}
\description{
R bindings to the Odiff command-line tool for blazing-fast, pixel-by-pixel
image comparison. Ideal for visual regression testing, quality assurance,
and validated environments.
}
\section{Main Functions}{


\describe{
\item{\code{\link[=compare_images]{compare_images()}}}{High-level image comparison returning a
tibble/data.frame. Accepts file paths or magick-image objects.}
\item{\code{\link[=odiff_run]{odiff_run()}}}{Low-level CLI wrapper with full control over
all Odiff options. Returns a detailed result list.}
\item{\code{\link[=ignore_region]{ignore_region()}}}{Helper to create ignore region specifications.}
}
}

\section{Binary Management}{


\describe{
\item{\code{\link[=find_odiff]{find_odiff()}}}{Locate the Odiff binary using priority search.}
\item{\code{\link[=odiff_available]{odiff_available()}}}{Check if Odiff is available.}
\item{\code{\link[=odiff_version]{odiff_version()}}}{Get the Odiff version string.}
\item{\code{\link[=odiff_info]{odiff_info()}}}{Display full configuration information.}
\item{\code{\link[=odiffr_update]{odiffr_update()}}}{Download latest Odiff binary to user cache.
Useful for updating between package releases.}
\item{\code{\link[=odiffr_cache_path]{odiffr_cache_path()}}}{Get the cache directory path.}
\item{\code{\link[=odiffr_clear_cache]{odiffr_clear_cache()}}}{Remove cached binaries.}
}
}

\section{Binary Detection Priority}{


The package searches for the Odiff binary in this order:
\enumerate{
\item User-specified path via \code{options(odiffr.path = "/path/to/odiff")}
\item System PATH (\code{Sys.which("odiff")})
\item Cached binary from \code{odiffr_update()}
}
}

\section{Supported Image Formats}{


\describe{
\item{Input}{PNG, JPEG, WEBP, TIFF (cross-format comparison supported)}
\item{Output}{PNG only}
}
}

\section{Exit Codes}{


\describe{
\item{0}{Images match}
\item{21}{Layout difference (different dimensions)}
\item{22}{Pixel differences found}
}
}

\section{For Validated Environments}{


The package is designed for use in validated pharmaceutical and clinical
research environments:

\itemize{
\item Pin specific binary versions with \code{options(odiffr.path = "/validated/odiff")}
\item Zero external runtime dependencies (base R only for core functions)
\item Use \code{odiff_version()} to document binary version for audit trails
}
}

\section{Author}{


Ben Wolstenholme
}

\section{See Also}{


\itemize{
\item \url{https://github.com/dmtrKovalenko/odiff} - Odiff project
\item \url{https://github.com/BenWolst/odiffr} - Odiffr package
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/BenWolst/odiffr}
  \item Report bugs at \url{https://github.com/BenWolst/odiffr/issues}
}

}
\author{
\strong{Maintainer}: Ben Wolstenholme \email{odiffr@benwolst.dev}

}
\keyword{internal}
