% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_images.R
\name{compare_dirs_report}
\alias{compare_dirs_report}
\title{Compare Directories and Generate HTML Report}
\usage{
compare_dirs_report(
  baseline_dir,
  current_dir,
  diff_dir = "diffs",
  output_file = file.path(diff_dir, "report.html"),
  parallel = FALSE,
  title = "odiffr Comparison Report",
  embed = FALSE,
  relative_paths = FALSE,
  n_worst = 10,
  show_all = FALSE,
  ...
)
}
\arguments{
\item{baseline_dir}{Path to the directory containing baseline images.}

\item{current_dir}{Path to the directory containing current images to
compare against baseline.}

\item{diff_dir}{Directory to save diff images. If \code{NULL}, no diff images
are created.}

\item{output_file}{Path for the HTML report. Defaults to
\code{file.path(diff_dir, "report.html")}.}

\item{parallel}{Logical; if \code{TRUE}, compare images in parallel. See
\code{\link[=compare_images_batch]{compare_images_batch()}} for details.}

\item{title}{Title for the HTML report.}

\item{embed}{Logical; if \code{TRUE}, embed images as base64 data URIs for a
self-contained report. If \code{FALSE} (default), link to image files.}

\item{relative_paths}{Logical; if \code{TRUE}, use relative paths for images
in the HTML report. Makes reports portable without embedding. Ignored
when \code{embed = TRUE}. Default: \code{FALSE}.}

\item{n_worst}{Number of worst offenders to display in the report.}

\item{show_all}{Logical; if \code{TRUE}, show all comparisons in the report,
not just failures.}

\item{...}{Additional arguments passed to \code{\link[=compare_image_dirs]{compare_image_dirs()}} (e.g.
\code{threshold}, \code{antialiasing}, \code{pattern}, \code{recursive}).}
}
\value{
The \code{odiffr_batch} results (invisibly). The HTML report is written
to \code{output_file} as a side effect.
}
\description{
Convenience function that compares all images in two directories and
generates an HTML report in one step.
}
\examples{
\dontrun{
# One-liner for QA workflow
compare_dirs_report("baseline/", "current/")
# -> Creates diffs/ directory with diff images and report.html

# With parallel processing and embedded images
compare_dirs_report("baseline/", "current/", parallel = TRUE, embed = TRUE)

# Pass comparison options via ...
compare_dirs_report("baseline/", "current/", threshold = 0.1, antialiasing = TRUE)
}
}
\seealso{
\code{\link[=compare_image_dirs]{compare_image_dirs()}}, \code{\link[=batch_report]{batch_report()}}
}
