% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocrRBBR_single_cell.R
\name{ocrRBBR_single_cell}
\alias{ocrRBBR_single_cell}
\title{Predicts OCR-driven Boolean rules for a gene}
\usage{
ocrRBBR_single_cell(
  rnaseq_data,
  atacseq_data,
  gene_name,
  peak_ids,
  max_feature = NA,
  slope = NA,
  num_cores = NA,
  ESS = NA,
  meta_data,
  verbose = FALSE
)
}
\arguments{
\item{rnaseq_data}{A numeric matrix of RNA-seq expression values. Rows correspond to genes, columns
correspond to cells or samples. RNA-seq values are assumed to be normalized using Seurat's
\code{LogNormalize} method with a scale factor of 10,000:
\code{NormalizeData(seurat_obj, normalization.method = "LogNormalize", scale.factor = 1e4)}.}

\item{atacseq_data}{A numeric matrix of ATAC-seq signal intensities. Rows correspond to peaks,
  columns correspond to cells or samples. ATAC-seq counts are assumed to be normalized
  by the \code{ReadsInTSS} metric on a per-cell basis, where raw peak counts are divided by
  the number of Tn5 insertions falling within transcription start site (TSS) regions for each cell.
  This normalization corrects for differences in sequencing depth and chromatin accessibility
  signal across cells.

  \code{ReadsInTSS} values are typically obtained from \code{ArchR} and applied as column-wise scaling
  factors to the ATAC-seq count matrix prior to downstream analysis.}

\item{gene_name}{A character string specifying the gene for which to infer Boolean rules.}

\item{peak_ids}{A vector of peak identifiers corresponding to rows in \code{atacseq_data} to be used as candidate regulatory regions for \code{gene_name}.}

\item{max_feature}{An integer specifying the maximum number of input features allowed in a Boolean rule. Default is 3.}

\item{slope}{The slope parameter for the sigmoid activation function. Default is 10.}

\item{num_cores}{Number of parallel workers to use for computation. Adjust according to your system. Default is NA.}

\item{ESS}{Effective sample size of the single-cell data after accounting for noise and cell-to-cell correlation.}

\item{meta_data}{A numeric matrix or data.frame containing additional
  per-cell covariates (rows = cells, columns = covariates), such as:

**nCount_RNA**: The total number of RNA molecules (unique molecular identifiers, UMIs) detected per cell, calculated as the sum of UMI counts across all genes.

**nFeature_RNA**: The number of genes detected per cell (genes with at least one UMI).

**Mitochondrial percentage**: The percentage of reads that map to mitochondrial genes, which can be used to assess the quality of the sample.

This information is typically stored as columns in the \code{meta_data} object, which is associated with each cell in the dataset.}

\item{verbose}{Logical. If TRUE, progress messages and a progress bar are shown. Default is FALSE.}
}
\value{
A list containing predicted Boolean rules and associated metrics for the input gene.
}
\description{
This function predicts Boolean rule sets for a given gene using single-cell multi-omics datasets,
including RNA-seq gene expression and ATAC-seq peak signals in the gene's flanking regions,
across samples.
}
\examples{
# Load single-cell human dataset
data(multiome_human_mouse)  # loads atacseq_data, rnaseq_data, peaks_gr, meta_data

# Example usage:
peak_ids <- c(83456, 83458, 83460)

boolean_rules <- ocrRBBR_single_cell(human_rnaseq_data, human_atacseq_data,
       "CD74", peak_ids = peak_ids, max_feature = 3, slope = 6,
        num_cores = 1, ESS = 261, meta_data = human_meta_data)

}
