% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESS.R
\name{ESS}
\alias{ESS}
\title{Estimate Effective Sample Size from Single-Cell RNA-seq Data}
\usage{
ESS(rnaseq_data, cell_type, verbose = FALSE)
}
\arguments{
\item{rnaseq_data}{A numeric matrix of RNA-seq expression values.
Rows correspond to genes and columns correspond to cells.
Expression values are assumed to be normalized (e.g., \code{Seurat LogNormalize} with \code{scale.factor = 1e4}).}

\item{cell_type}{A data frame containing cell-type information.
Row names must match the column names of \code{rnaseq_data}.
Must include a column named \code{cell_type} specifying cell types.}

\item{verbose}{Logical. If TRUE, progress messages are printed.}
}
\value{
A numeric value representing the effective sample size (ESS),
  adjusted for within-cell-type correlation.
}
\description{
This function estimates the effective sample size (ESS) of single-cell RNA-seq data
by accounting for correlation among cells within the same cell type.
}
