% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{qb_intervals}
\alias{qb_intervals}
\title{Formant and amplitude for intervals of QuakeBox monologues}
\format{
A data frame with 53940 rows and 10 variables:
\describe{
\item{interval_length}{Length of interval in seconds.}
\item{speaker}{Anonymised speaker code (char).}
\item{interval}{Time in seconds at which interval ends.}
\item{articulation_rate}{Mean articulation rate within interval.}
\item{amplitude}{Mean maximum amplitude within interval.}
\item{DRESS_F1}{Speaker intercept from GAMM model of DRESS F1.}
\item{DRESS_F2}{Speaker intercept from GAMM model of DRESS F2.}
\item{FLEECE_F1}{Speaker intercept from GAMM model of FLEECE F1.}
\item{FLEECE_F2}{Speaker intercept from GAMM model of FLEECE F2.}
\item{GOOSE_F1}{Speaker intercept from GAMM model of GOOSE F1.}
\item{GOOSE_F2}{Speaker intercept from GAMM model of GOOSE F2.}
\item{KIT_F1}{Speaker intercept from GAMM model of KIT F1.}
\item{KIT_F2}{Speaker intercept from GAMM model of KIT F2.}
\item{LOT_F1}{Speaker intercept from GAMM model of LOT F1.}
\item{LOT_F2}{Speaker intercept from GAMM model of LOT F2.}
\item{NURSE_F1}{Speaker intercept from GAMM model of NURSE F1.}
\item{NURSE_F2}{Speaker intercept from GAMM model of NURSE F2.}
\item{START_F1}{Speaker intercept from GAMM model of START F1.}
\item{START_F2}{Speaker intercept from GAMM model of START F2.}
\item{STRUT_F1}{Speaker intercept from GAMM model of STRUT F1.}
\item{STRUT_F2}{Speaker intercept from GAMM model of STRUT F2.}
\item{THOUGHT_F1}{Speaker intercept from GAMM model of THOUGHT F1.}
\item{THOUGHT_F2}{Speaker intercept from GAMM model of THOUGHT F2.}
\item{TRAP_F1}{Speaker intercept from GAMM model of TRAP F1.}
\item{TRAP_F2}{Speaker intercept from GAMM model of TRAP F2.}
}
}
\source{
\url{https://osf.io/m8nkh/}
}
\usage{
qb_intervals
}
\description{
QuakeBox monologues are divided into intervals of fixed length within mean
values are calcualted for formants, amplitude, and articulation rate. Data
from 77 speakers is provide (the same sample as \code{qb_vowels}).
}
\details{
Two interval lengths are given: 60 seconds and 240 seconds.

Formant data is z-scored by speaker and vowel, while the amplitude and
articulation rate are z-scored by speaker.

Original data was generated for Wilson Black et al. (2023).
}
\references{
Wilson Black, Joshua, Jennifer Hay, Lynn Clark & James Brand (2023): The
overlooked effect of amplitude on within-speaker vowel variation.
Linguistics Vanguard. Walter de Gruyter GmbH. 9(1). 173–189.
doi:10.1515/lingvan-2022-0086
}
\keyword{datasets}
