% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateLayerUtterances.R
\name{generateLayerUtterances}
\alias{generateLayerUtterances}
\title{Generates a layer for a given set of utterances}
\usage{
generateLayerUtterances(
  labbcat.url,
  match.ids,
  layer.id,
  collection.name = NULL,
  no.progress = FALSE
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{match.ids}{A vector of annotation IDs, e.g. the MatchId column, or the URL column,
of a results set.}

\item{layer.id}{The ID of the layer to generate.}

\item{collection.name}{An optional name for the collection, e.g. the participant ID.}

\item{no.progress}{TRUE to suppress visual progress bar. Otherwise, progress bar will be
shown when interactive().}
}
\value{
The final status of the layer generation task.
}
\description{
Generates annotations on a given layer for a given set of utterances, e.g. force-align
selected utterances of a participant.
}
\examples{
\dontrun{
## Get all utterances of a participant
allUtterances <- getAllUtterances(labbcat.url, "AP2505_Nelson")

## Force-align the participant's utterances
generateLayerUtterances(labbcat.url, allUtterances$MatchId, "htk", "AP2505_Nelson")
}

}
\seealso{
\link{getAllUtterances}
}
\keyword{annotation}
\keyword{label}
\keyword{layer}
