% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentAudio.R
\name{fragmentAudio}
\alias{fragmentAudio}
\title{Gets sound fragments from 'LaBB-CAT'.}
\usage{
fragmentAudio(
  matches,
  sample.rate = NULL,
  path = "",
  no.progress = FALSE,
  start.column = Line,
  end.column = LineEnd,
  labbcat.url = NULL
)
}
\arguments{
\item{matches}{A dataframe returned by \link{getMatches} or \link{getAllUtterances}, identifying
the results to which acoustic measurments should be appended.}

\item{sample.rate}{Optional sample rate in Hz - if a positive
integer, then the result is a mono file with the given sample rate.}

\item{path}{Optional path to directory where the files should be saved.}

\item{no.progress}{TRUE to suppress visual progress bar. Otherwise, progress bar will be
shown when interactive().}

\item{start.column}{The column of \code{matches} containing the start time in seconds.}

\item{end.column}{The column of \code{matches} containing the end time in seconds.}

\item{labbcat.url}{URL to the LaBB-CAT instance (instead of inferring it from \code{matches}).}
}
\value{
\code{matches} with the acoustic measurements appended as new columns.
}
\description{
This is a version of \link{getSoundFragments} that can have a
dataframe of matches piped into it.
}
\details{
It gets fragments of audio from LaBB-CAT, as wav files.
}
\examples{
\dontrun{
## Get all tokens of "the"
the.tokens <- getMatches(labbcat.url, "the")
## Get a 22kHz sample rate wav file for each matched utterance
the.wavs <- the.tokens |> fragmentTranscripts(sample.rate = 22050)
}
}
\seealso{
\itemize{
\item \link{processWithPraat}
\item \link{getMatches}
}
}
\keyword{praat}
