% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r0cat.R
\name{r0cat}
\alias{r0cat}
\title{Row-constrained categorical randomization (r0cat)}
\usage{
r0cat(x, n_iter = 1L, output = c("category", "index"), seed = NULL)
}
\arguments{
\item{x}{A matrix of categorical data, encoded as integers.
Values should represent category or stratum membership for each cell.}

\item{n_iter}{Number of iterations. Default is 1000. Larger values yield
more thorough mixing. Ignored for non-sequential methods. Minimum
burn-in times can be estimated with \code{suggest_n_iter()}.}

\item{output}{Character indicating type of result to return:
\itemize{
\item \code{"category"} (default) returns randomized matrix
\item \code{"index"} returns an index matrix describing where original
entries (a.k.a. "tokens") moved. Useful mainly for testing, and for
applications like \code{quantize()} that care about token tracking
in addition to generic integer categories.
}}

\item{seed}{Integer used to seed random number generator, for reproducibility.}
}
\value{
A matrix of the same dimensions as \code{x}, either randomized
categorical values (when \code{output = "category"}) or an integer index
matrix describing the permutation of entries (when \code{output = "index"}).
}
\description{
\code{r0cat()} preserves the multiset of categories within each row but
randomizes their positions across columns, leaving column margins free.
This is the categorical analog to vegan's \code{r0} algorithm. It is a
non-sequential method.
}
\examples{
set.seed(123)
x <- matrix(sample(1:4, 100, replace = TRUE), nrow = 10)

# Randomize within rows (row margins fixed, column margins free)
x_rand <- r0cat(x)

# Verify rows are preserved but columns are not
all.equal(sort(x[1, ]), sort(x_rand[1, ]))
any(sort(x[, 1]) != sort(x_rand[, 1]))

}
