print.np.lm.test <-
  function(x, digits = 4, n = 10, ...){
    
    # get info
    homoscedastic <- ifelse(x$homosced, "Homoscedastic", "Heteroscedastic")
    method <- ifelse(x$method == "perm", "Permute",
                     ifelse(x$method == "flip", "Flip Sign", 
                            ifelse(x$method == "both", 
                                   "Flip Sign & Permute", NA)))
    univar <- is.null(x$univariate)
    statistic <- paste(ifelse(x$homosced, "F =", "W ="), round(x$statistic, digits))
    p.value <- round(x$p.value, digits)
    
    # print info
    if(univar){
      cat("\nNonparametric Linear Model Test (", homoscedastic,")\n", sep = "")
    } else {
      cat("\nMultivariate Nonparametric Linear Model Test (", homoscedastic,")\n", sep = "")
    }
    cat("randomization method:", method, "\n")
    #cat(statistic, ",  p-value = ", p.value, "\n", sep = "")
    cat("\nsignificance tests (type III SS):\n")
    print(x$signif.table, row.names = FALSE)
    if(length(x$coef) <= n){
      cat("\nsample estimates:", "\n", sep = "")
      print(round(x$coef, digits))
    }
    cat("\n")
    
  }