% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_replace_na.R
\name{nest_replace_na}
\alias{nest_replace_na}
\title{Replace NAs with specified values in a column of nested data frames}
\usage{
nest_replace_na(.data, .nest_data, replace, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{replace}{A list of values, with one value for each column in that has \code{NA} values
to be replaced.}

\item{...}{Additional arguments for \code{\link[tidyr:replace_na]{tidyr::replace_na()}} methods. Currently unused.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will have NAs replaced in the specified columns.
}
\description{
\code{nest_replace_na()} is used to replace missing values in selected columns of
nested data frames using values specified by column.
}
\details{
\code{nest_replace_na()} is a wrapper for \code{\link[tidyr:replace_na]{tidyr::replace_na()}} and maintains the functionality
of \code{replace_na()} within each nested data frame. For more information on \code{replace_na()}
please refer to the documentation in \href{https://tidyr.tidyverse.org/}{'tidyr'}.
}
\examples{
set.seed(123)
gm <- 
  gapminder::gapminder \%>\% 
  dplyr::mutate(pop = dplyr::if_else(runif(dplyr::n()) >= 0.9,
                                     NA_integer_,
                                     pop))
                                     
gm_nest <- gm \%>\% tidyr::nest(country_data = -continent)

gm_nest \%>\% 
  nest_replace_na(.nest_data = country_data,
                  replace = list(pop = -500))
}
\seealso{
Other tidyr verbs: 
\code{\link{nest_drop_na}()},
\code{\link{nest_extract}()},
\code{\link{nest_fill}()},
\code{\link{nest_separate}()},
\code{\link{nest_unite}()}
}
\concept{tidyr verbs}
