% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_join.R
\name{nest-filter-joins}
\alias{nest-filter-joins}
\alias{nest_semi_join}
\alias{nest_anti_join}
\title{Nested filtering joins}
\usage{
nest_semi_join(.data, .nest_data, y, by = NULL, copy = FALSE, ...)

nest_anti_join(.data, .nest_data, y, by = NULL, copy = FALSE, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{y}{A data frame, data frame extension (e.g., a tibble), or a lazy data
frame (e.g., from dbplyr or dtplyr).}

\item{by}{A character vector of variables to join by or a join specification
created with \code{join_by()}.

If \code{NULL}, the default, \verb{nest_*_join()} will perform a natural join, using
all variables in common across each object in \code{.nest_data} and \code{y}. A
message lists the variables so you can check they're correct; suppress the
message by supplying \code{by} explicitly.

To join on different variables between the objects in \code{.nest_data} and \code{y},
use a named vector. For example, \code{by = c("a" = "b")} will match
\code{.nest_data$a} to \code{y$b} for each object in \code{.nest_data}.

To join by multiple variables, use a vector with length >1. For example,
\code{by = c("a", "b")} will match \code{.nest_data$a} to \code{y$a} and \code{.nest_data$b} to
\code{y$b} for each object in \code{.nest_data}. Use a named vector to match
different variables in \code{.nest_data} and \code{y}. For example,
\code{by = c("a" = "b", "c" = "d")} will match \code{.nest_data$a} to \code{y$b} and
\code{.nest_data$c} to \code{y$d} for each object in \code{.nest_data}.

To perform a cross-join, generating all combinations of each object in
\code{.nest_data} and \code{y}, use \code{by = character()}.}

\item{copy}{If \code{.nest_data} and \code{y} are not from the same data source and
\code{copy = TRUE} then \code{y} will be copied into the same src as \code{.nest_data}.
\emph{(Need to review this parameter in more detail for applicability with nplyr)}}

\item{...}{One or more unquoted expressions separated by commas. Variable
names can be used if they were positions in the data frame, so expressions
like \code{x:y} can be used to select a range of variables.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will also be of the same type as the input. Each object in \code{.nest_data} has
the following properties:
\itemize{
\item Rows are a subset of the input, but appear in the same order.
\item Columns are not modified.
\item Data frame attributes are preserved.
\item Groups are taken from \code{.nest_data}. The number of groups may be reduced.
}
}
\description{
Nested filtering joins filter rows from \code{.nest_data} based on the presence or
absence of matches in \code{y}:
\itemize{
\item \code{nest_semi_join()} returns all rows from \code{.nest_data} with a match in \code{y}.
\item \code{nest_anti_join()} returns all rows from \code{.nest_data} with\emph{out} a match in \code{y}.
}
}
\details{
\code{nest_semi_join()} and \code{nest_anti_join()} are largely wrappers for
\code{\link[dplyr:filter-joins]{dplyr::semi_join()}} and \code{\link[dplyr:filter-joins]{dplyr::anti_join()}} and maintain the functionality
of \code{semi_join()} and \code{anti_join()} within each nested data frame. For more
information on \code{semi_join()} or \code{anti_join()}, please refer to the
documentation in \href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)
gm_codes <- gapminder::country_codes \%>\% dplyr::slice_sample(n = 10)

gm_nest \%>\% nest_semi_join(country_data, gm_codes, by = "country")
gm_nest \%>\% nest_anti_join(country_data, gm_codes, by = "country")

}
\seealso{
Other joins: 
\code{\link{nest-mutate-joins}},
\code{\link{nest_nest_join}()}
}
\concept{joins}
