% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{liposome_fluor_dbfs}
\alias{liposome_fluor_dbfs}
\alias{norm_tidy_dbf}
\alias{normfluordbf}
\alias{normfluodbf}
\title{Cleans and Normalizes DBF files obtained from experiments using the FLUOstar Omega microplate reader (from BMG LABTECH).}
\usage{
norm_tidy_dbf(
  file = NULL,
  norm_scale = NULL,
  transformed = NULL,
  fun = NA,
  ...
)

normfluordbf(file = NULL, norm_scale = NULL, transformed = NULL, fun = NA, ...)

normfluodbf(file = NULL, norm_scale, transformed = NULL, fun = NA, ...)
}
\arguments{
\item{file}{A string ("liposomes_xxx.dbf") if the file is found within the present working directory (pwd) OR a path pointing directly to a ".dbf" file.}

\item{norm_scale}{This parameter takes sub-parameters: 'raw’ , hundred’ , 'one’ , 'z-score' , or 'decimal’ , which denotes the normalization type or scale; The parameter is initialized as NULL.}

\item{transformed}{This parameter takes input 'log', which denotes a logarithmic box-cox transformation; Initialized as NULL.}

\item{fun}{A parameter defined as NA is used for Boolean expressions or manipulation.}

\item{...}{An abstract placeholder or container parameter that can be used to capture extra variables if needed.}
}
\value{
A normalized data frame with an appended "Cycle_Number" attribute.

A normalized data frame with an appended "Cycle_Number" attribute.

A normalized data frame with an appended "Cycle_Number" attribute.

A normalized data frame with an appended "Cycle_Number" attribute.
}
\description{
The simplest function utilization scenario entails an input of the path to a DBF file obtained from the FLUOstar microplate (usually a 96-well microplate) reader;
In a single step, this function will create a data frame, clean the data frame, normalize the data frame, append a "Cycle_Number" attribute,
perform an adjustment to the “time” attribute and return a data frame that is ready for analysis.
Since the initial publication of this package, several changes have been made to improve the user experience and to give the user more options
to fine-tune the output from the package to meet the users’ aesthetic needs.
Users who decide to move past the simplest utility scenario have been given more options to customize the output based on the users’ needs.
Notably, several normalization sub-parameters have been provided in the package which yields different outputs based on what the user is used to seeing.
Just as the FLUOstar instrument is built to handle an array of assays,
this function is designed to be multi-dimensional (meaning it can handle data with the same DBF extension from other assay types),
on the condition that the data from assay types other than liposome flux assays follow the same data format this package was designed to handle.
Of course, users of this package are advised to pre-analyze DBF files from other assay types to ensure they are compliant with this package (compliance in this scenario is simple meaning DBF files from other assays should be like DBF files from liposome flux assays).
}
\note{
The default normalization sub-parameter outputs values in the 0-1 range.
Unless a “norm_scale” level is specified by the user, the default output is in the 0-1 range.
The “norm_scale” sub-parameter “decimal” is a machine-learning tool and should be avoided;
it also provides no advantage for basic research analysis as its output operates on a sliding scale just like the raw data.
Logarithmic transformation provides a minuscule advantage in data analysis and could/should be avoided.
Backward compatibility is maintained in all updates, so there should be no issues with using the package the way the user was used to.
The favorite "norm_scale" level is "z-score" since it divides the axis into negative and positive, thus facilitating interpretation.

The norm_scale must be provided if the user chooses to use this option.
}
\examples{
\dontrun{
fpath <- system.file("extdata", "liposomes_214.dbf", package = "normfluodbf", mustWork = TRUE)
normalized_dbf <- norm_tidy_dbf(file=fpath, norm_scale = 'raw')
normalized_dbf <- normfluordbf(file=fpath, norm_scale = 'raw')}
\dontrun{wells = normfluodbf(lipsum_214, norm_scale = 'hundred')}
}
\seealso{
\code{\link[=normfluordbf]{normfluordbf()}}, \code{\link[=normfluodat]{normfluodat()}}
}
\author{
Tingwei Adeck
}
\concept{normfluodbf}
