library(testthat)
library(nonparTrendR)

test_that("independent samples test runs", {
  groups <- list(rnorm(10), rnorm(10, mean=1))
  result <- nonparTrendR_test(groups, type="I")
  expect_s3_class(result, "htest")
})

test_that("dependent samples test runs", {
  mat <- matrix(rnorm(30), nrow=10, ncol=3)
  result <- nonparTrendR_test(mat, type="D")
  expect_s3_class(result, "htest")
})
