% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agq.R
\name{agqControl}
\alias{agqControl}
\title{Control options for the agq estimation method}
\usage{
agqControl(
  sigdig = 3,
  nAGQ = 2,
  ...,
  interaction = TRUE,
  agqLow = -Inf,
  agqHi = Inf
)
}
\arguments{
\item{sigdig}{Optimization significant digits. This controls:

\itemize{

 \item The tolerance of the inner and outer optimization is \code{10^-sigdig}

 \item The tolerance of the ODE solvers is
 \code{0.5*10^(-sigdig-2)}; For the sensitivity equations and
 steady-state solutions the default is \code{0.5*10^(-sigdig-1.5)}
 (sensitivity changes only applicable for liblsoda)

 \item The tolerance of the boundary check is \code{5 * 10 ^ (-sigdig + 1)}

}}

\item{nAGQ}{Number of Gauss-Hermite Adaptive Quadrature points to
take.  When `nAGQ=0`, the AGQ is not used.  With `nAGQ=1`, this
is equivalent to the Laplace method. The adaptive quadrature
expands every node for each of the ETAs, so it can be quite
expensive with a large amount of ETAs.  Once the EBE is obtained
for a subject, you will have nAGQ^neta additional function
evaluations for even nAGQ numbers and (nAGQ^neta)-1 additional
function evaluations for odd nAGQ numbers.}

\item{...}{Parameters used in the default `foceiControl()`}

\item{interaction}{boolean, Interaction term for the model, in this
case the default is `TRUE`; For adaptive quadrature, with normal
distribution the Hessian is calculated with the foce(i)
approximation}

\item{agqLow}{The lower bound for adaptive quadrature
log-likelihood. By default this is -Inf; in the original nlmixr's
gnlmm it was -700.}

\item{agqHi}{The upper bound for adaptive quadrature
log-likelihood.  By default this is Inf; in the original nlmixr's
gnlmm was 400.}
}
\value{
agqControl object
}
\description{
This is the control options for the adaptive Gauss-Hermite
quadrature for the likelihood.  Note that nAGQ=1 is the same as the
Laplace method.
}
\examples{

\donttest{

agqControl()

# Use adaptive quadrature

# x =  Litter size after 21 days, and the modeled value

r <- rats
r$dv <- r$x

# Time is not used in this model, but it is required in nlmixr2
# currently, add a dummy value

r$time <- 0

f <- function() {
  ini({
    t1 <- 1
    t2 <- 1
    t3 <- 1
    eta1 ~ 1
  })
  model({
    lp <- t1 * x1 + t2 * x2 + (x1 + x2*t3) * eta1
    p <- pnorm(lp)
    m1 <- m # need to add outside of model specification
    x ~ dbinom(m1, p)
  })
}

fit <- nlmixr(f, r, est="agq")


p <- pump

p$dv <- p$y
p$time <- 0 # dummy time

f <- function() {
  ini({
    t1 <- 1
    t2 <- 1
    t3 <- 1
    t4 <- 1
    eta1 ~ 1
  })
  model({
    if (group == 1) {
       lp <- t1 + t2 * logtstd
    } else {
       lp <- t3 + t4 * logtstd
    }
    lp <- lp + eta1
    lam <- exp(lp)
    y ~ dpois(lam)
  })
}

fit <- nlmixr(f, p, est="agq", control=agqControl(nAGQ=5))

one.cmt <- function() {
  ini({
    ## You may label each parameter with a comment
    tka <- 0.45 # Log Ka
    tcl <- log(c(0, 2.7, 100)) # Log Cl
    ## This works with interactive models
    ## You may also label the preceding line with label("label text")
    tv <- 3.45; label("log V")
    ## the label("Label name") works with all models
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
 })
 model({
   ka <- exp(tka + eta.ka)
   cl <- exp(tcl + eta.cl)
   v <- exp(tv + eta.v)
   linCmt() ~ add(add.sd)
 })
}

fit <- nlmixr(one.cmt, theo_sd, est="agq")

}

}
\author{
Matthew L. Fidler
}
