% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.operator.R
\name{step_correlation}
\alias{step_correlation}
\title{Evaluate inclusion of ETA correlation structure}
\usage{
step_correlation(
  dat,
  start.mod = NULL,
  search.space = "ivbase",
  no.cores = NULL,
  param_table = NULL,
  penalty.control = NULL,
  precomputed_results_file = NULL,
  filename = "test",
  foldername = NULL,
  .modEnv = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data in standard
nlmixr2 format, including "ID", "TIME", "EVID", and "DV", and may include
additional columns.}

\item{start.mod}{A named integer vector specifying the starting model
code. If NULL, a base model is generated using \code{base_model()}.}

\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{no.cores}{Integer. Number of CPU cores to use. If NULL, uses
\code{rxode2::getRxThreads()}.}

\item{param_table}{Optional data frame of initial parameter estimates. If NULL,
the table is generated by \code{auto_param_table()}.}

\item{penalty.control}{A list of penalty control parameters defined by
\code{penaltyControl()}, specifying penalty values used for model diagnostics
during fitness evaluation.}

\item{precomputed_results_file}{Optional path to a CSV file of previously computed
model results used for caching.}

\item{filename}{Optional character string used as a prefix for output files.
Defaults to "test".}

\item{foldername}{Character string specifying the name of the folder to be
created in the current working directory to store intermediate results.
If NULL, a name is generated automatically.}

\item{.modEnv}{Optional environment used to store model indices and cached
results across steps.}

\item{verbose}{Logical. If TRUE, print progress messages.}

\item{...}{Additional arguments passed to the model estimation function.}
}
\value{
A list with the following elements:
\itemize{
\item results_table: A data frame summarizing the evaluated models,
\item best_code: A named integer vector corresponding to the selected
model code,
\item best_row: A one-row data frame containing the summary of the
selected model.
}
}
\description{
Evaluates whether correlation between inter-individual random
effects (ETA correlation) should be included in the model.
}
\details{
Two candidate models are constructed by toggling the correlation setting
of inter-individual random effects in the model code. Model selection is
based on comparison of Fitness values returned during estimation.
}
\examples{
\donttest{
  dat <- pheno_sd
  param_table <- initialize_param_table()
  param_table$init[param_table$Name == "lcl"] <- log(0.008)
  param_table$init[param_table$Name == "lvc"] <- log(0.6)
  penalty.control <- penaltyControl()
  penalty.control$penalty.terms <-
    c("rse", "theta", "covariance", "shrinkage", "omega")
  start.mod <- base_model("ivbase")
  start.mod["eta.vc"] <- 1L
  step_correlation(
    dat = dat,
    start.mod = start.mod,
    search.space = "ivbase",
    param_table = param_table,
    filename = "step_mcorr_test",
    penalty.control = penalty.control,
    saem.control = nlmixr2est::saemControl(logLik = TRUE,nBurn=15,nEm=15)
  )
}

}
\seealso{
\code{\link{mod.run}}, \code{\link{base_model}}, \code{\link{penaltyControl}}
}
\author{
Zhonghui Huang
}
