% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.operator.R
\name{step_compartments}
\alias{step_compartments}
\title{Screen number of compartments}
\usage{
step_compartments(
  dat,
  start.mod = NULL,
  search.space = "ivbase",
  no.cores = NULL,
  param_table = NULL,
  penalty.control = NULL,
  precomputed_results_file = NULL,
  filename = "test",
  foldername = NULL,
  .modEnv = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data in standard
nlmixr2 format, including "ID", "TIME", "EVID", and "DV", and may include
additional columns.}

\item{start.mod}{A named integer vector specifying the starting model
code. If NULL, a base model is generated using \code{base_model()}.}

\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{no.cores}{Integer. Number of CPU cores to use. If NULL, uses
\code{rxode2::getRxThreads()}.}

\item{param_table}{Optional data frame of initial parameter estimates. If NULL,
the table is generated by \code{auto_param_table()}.}

\item{penalty.control}{A list of penalty control parameters defined by
\code{penaltyControl()}, specifying penalty values used for model diagnostics
during fitness evaluation.}

\item{precomputed_results_file}{Optional path to a CSV file of previously computed
model results used for caching.}

\item{filename}{Optional character string used as a prefix for output files.
Defaults to "test".}

\item{foldername}{Character string specifying the folder name for storing
intermediate results. If \code{NULL} (default), \code{tempdir()}
is used for temporary storage. If specified, a cache directory
is created in the current working directory.}

\item{.modEnv}{Internal environment used to store model indices and cached
results across steps.}

\item{verbose}{Logical. If TRUE, print progress messages.}

\item{...}{Additional arguments passed to mod.run. These may include
custom_base, which is used to initialize the baseline model when no
best_code is present in start.mod.}
}
\value{
A list with the following elements:
\itemize{
\item results_table: a data frame with one row per candidate model,
including model description and fit statistics
\item best_code: named integer vector corresponding to the best candidate
\item best_row: one-row data frame containing the best candidate summary
}
}
\description{
Runs candidate models with one, two, and three compartments by modifying only
the compartment setting in the current model code.
}
\details{
Three candidate models are created by modifying only the number of
compartments in the starting model code. The candidate codes are evaluated
sequentially, and a results table containing model names, model codes,
Fitness values, and information criteria is returned for logging and
decision making.
}
\examples{
\donttest{
  dat <- pheno_sd
  string <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 1)
  param_table <- initialize_param_table()
  param_table$init[param_table$Name == "lcl"] <- log(0.008)
  param_table$init[param_table$Name == "lvc"] <- log(0.6)
  penalty.control = penaltyControl()
  penalty.control$penalty.terms = c("rse", "theta", "covariance")
  step_compartments(
    dat = dat,
    search.space = "ivbase",
    param_table = param_table,
    filename = "step_cmpt_test",
    penalty.control = penalty.control,
    saem.control = nlmixr2est::saemControl(logLik = TRUE,nBurn=15,nEm=15)
  )
}

}
\seealso{
\code{\link{mod.run}}, \code{\link{base_model}}, \code{\link{penaltyControl}}
}
\author{
Zhonghui Huang
}
