% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runlocal.R
\name{runlocal}
\alias{runlocal}
\title{Perform 1-bit local search}
\usage{
runlocal(
  dat,
  param_table = NULL,
  search.space = c("ivbase", "oralbase"),
  no.cores = NULL,
  start.string = NULL,
  diff_tol = 1,
  penalty.control = penaltyControl(),
  precomputed_results_file = NULL,
  foldername = NULL,
  filename = "test",
  .modEnv = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data in standard
nlmixr2 format, including "ID", "TIME", "EVID", and "DV", and may include
additional columns.}

\item{param_table}{Optional data frame of initial parameter estimates. If NULL,
the table is generated by \code{auto_param_table()}.}

\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{no.cores}{Integer. Number of CPU cores to use. If NULL, uses
\code{rxode2::getRxThreads()}.}

\item{start.string}{Optional numeric/integer vector of 0 or 1 values giving the
starting binary code.}

\item{diff_tol}{A numeric value specifying the significance difference threshold.
Values within this threshold are considered equal and receive the same rank.
Default is 1.}

\item{penalty.control}{A list of penalty control parameters defined by
\code{penaltyControl()}, specifying penalty values used for model diagnostics
during fitness evaluation.}

\item{precomputed_results_file}{Optional path to a CSV file of previously computed
model results used for caching.}

\item{foldername}{Character string specifying the folder name for storing
intermediate results. If \code{NULL} (default), \code{tempdir()}
is used for temporary storage. If specified, a cache directory
is created in the current working directory.}

\item{filename}{Optional character string used as a prefix for output files.
Defaults to "test".}

\item{.modEnv}{Optional environment used to persist state across calls
(e.g., cached parameter tables and precomputed results). When \code{NULL},
a new environment is created.}

\item{verbose}{Logical. If TRUE, print progress messages.}

\item{...}{Additional arguments passed to \code{mod.run()}.}
}
\value{
A data frame where each row corresponds to a unique candidate model. Columns
include the binary encoding (one column per bit), the computed "fitness",
and the resulting "rank".
}
\description{
Runs a 1-bit neighbourhood local search on a binary-coded model string and
returns a data frame of candidate models with their computed fitness (and ranks).
}
\details{
For each position in the starting binary code, \code{runlocal()} constructs a
candidate by flipping that single bit (a 1-bit flip proposal). Some model
components are encoded by linked two-bit schemes (e.g., "no.cmpt1"/"no.cmpt2"
and "rv1"/"rv2"); when a proposal targets the second bit of a linked pair,
a feasibility rule is applied to maintain a valid encoding.

Each candidate is then canonicalised/validated using
\code{validStringbinary} before evaluation. Fitness is obtained by
calling \code{mod.run} for each candidate and results are ranked using
\code{rank_new}.

If ".modEnv" is supplied and contains the GA iteration counter ".modEnv$r",
local search does not advance this counter; implementations may decrement
".modEnv$r" (with a lower bound of 1) so that local search does not consume
a GA "round".
}
\examples{
\donttest{
  dat <- pheno_sd
# Example best model binary code
  current_code <- c(1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0)
  param_table <- initialize_param_table()
  param_table$init[param_table$Name == "lcl"] <- log(0.008)
  param_table$init[param_table$Name == "lvc"] <- log(0.6)
# Run local search
  result_local <- runlocal(
  dat                      = dat,
  search.space             = "ivbase",
  start.string             = current_code,
  filename                 = "local_search_test",
  saem.control = nlmixr2est::saemControl(logLik = TRUE,nBurn=15,nEm=15)
)
print(result_local)
}
}
\seealso{
\code{\link{mod.run}}, \code{\link{auto_param_table}}, \code{\link{validStringbinary}},
\code{\link{penaltyControl}}, \code{\link{rank_new}}
}
\author{
Zhonghui Huang
}
