% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga.cores.R
\name{ga.mutation}
\alias{ga.mutation}
\title{Mutation operator for binary genetic algorithms}
\usage{
ga.mutation(children.cross, pmut)
}
\arguments{
\item{children.cross}{Numeric matrix containing the child population. Rows are
individuals and columns are bits. Values are expected to be 0/1.}

\item{pmut}{Single numeric value in \eqn{[0, 1]} giving the per-bit mutation probability.}
}
\value{
Numeric matrix containing the mutated population.
}
\description{
Mutate a binary population by flipping bits with probability pmut.
}
\details{
Mutation is applied independently to each bit (gene). For each position, a
Bernoulli trial with success probability pmut determines whether the bit is
flipped (0 becomes 1, 1 becomes 0).
}
\examples{
children.cross <- matrix(sample(0:1, 120, replace = TRUE), nrow = 10)
ga.mutation(children.cross, pmut = 0.1)

}
\author{
Zhonghui Huang
}
