% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga.cores.R
\name{create.pop}
\alias{create.pop}
\title{Create an initial GA population}
\usage{
create.pop(npop, nbits)
}
\arguments{
\item{npop}{Integer. Number of individuals (chromosomes) in the population.}

\item{nbits}{Integer. Number of bits in each chromosome.}
}
\value{
A numeric matrix with npop rows and nbits columns containing only 0 and 1.
Each row corresponds to one chromosome.
}
\description{
Generates an initial population for a genetic algorithm (GA). Each individual
is a binary chromosome represented by a numeric vector containing 0 and 1.
}
\details{
Bits are sampled independently. Each bit takes the value 0 or 1 with equal
probability.
}
\examples{
create.pop(npop = 10, nbits = 12)

}
\author{
Zhonghui Huang
}
