% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelGen.R
\name{build_odeline}
\alias{build_odeline}
\title{Build ODE model lines for pharmacokinetic modeling}
\usage{
build_odeline(
  mm = 0,
  no.cmpt = 1,
  route = "bolus",
  abs.bio = 0,
  abs.type = 1,
  abs.delay = 0
)
}
\arguments{
\item{mm}{Michaelis-Menten elimination flag. 0 = linear elimination (default),
1 = Michaelis-Menten elimination.}

\item{no.cmpt}{Number of compartments. Supported values: 1 (central only),
2 (central + peripheral), or 3 (central + 2 peripheral).}

\item{route}{Administration route. Options: "bolus" (IV), "oral",
or "mixed_iv_oral".}

\item{abs.bio}{Bioavailability estimation flag. 0 = no bioavailability estimation (default),
1 = include bioavailability parameter (F1).}

\item{abs.type}{Absorption type for oral route:
\itemize{
\item 1 = First-order absorption (default)
\item 2 = Zero-order absorption
\item 3 = Sequential zero-first order absorption
\item 4 = Dual zero-first order absorption
}}

\item{abs.delay}{Absorption delay type:
\itemize{
\item 0 = No delay (default)
\item 1 = Lag time (tlag)
\item 2 = Transit compartment model
}}
}
\value{
A character vector containing ODE equations for the specified configuration.
Includes differential equations for drug compartments, absorption models,
and derived parameters.
}
\description{
Constructs a system of ordinary differential equations (ODEs) for pharmacokinetic modeling
with various configurations including different absorption models, compartmental structures,
and elimination kinetics.
}
\details{
Parameter Constraints:
The function includes error checking for incompatible parameter combinations:
\itemize{
\item abs.bio=1 cannot be used with abs.type=4 or abs.delay=3
\item Dual absorption (abs.type=4) not supported for mixed routes
}
}
\examples{
# Two-compartment model with first-order absorption
build_odeline(no.cmpt = 2, route = "oral")

# One-compartment IV model with Michaelis-Menten elimination
build_odeline(mm = 1, route = "bolus")
}
\author{
Zhonghui Huang
}
