% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validString.R
\name{applyParamDeps}
\alias{applyParamDeps}
\title{Apply parameter dependency rules}
\usage{
applyParamDeps(params)
}
\arguments{
\item{params}{Named list of model-code parameters. Elements are typically
scalar categorical values or 0/1 flags. Unknown elements are ignored.}
}
\value{
A named list with corrected parameter values.
}
\description{
Applies dependency constraints among structural and statistical flags in a
model-code parameter list to produce a feasible combination.
}
\details{
Corrections are applied in the following groups:
\itemize{
\item Compartment rules: disable peripheral IIV terms when "no.cmpt" implies
they are not used.
\item Michaelis-Menten rules: enable or disable "eta.vmax", "eta.km", and
"eta.cl" based on "mm".
\item Oral absorption rules: enable or disable oral-related terms based on
"abs.delay", "abs.type", and "abs.bio".
\item Correlation rules: disable "mcorr" when too few IIV terms are present.
\item IIV requirement: ensure at least one IIV term is present by enabling a
default term consistent with "mm".
}
}
\examples{
params <- list(
  no.cmpt = 1, mm = 0, mcorr = 1,
  eta.vc = 1, eta.cl = 0, eta.vp = 1, eta.q = 1
)
applyParamDeps(params)

params2 <- list(
  no.cmpt = 2, mm = 1,
  eta.vmax = 0, eta.km = 0, eta.cl = 1
)
applyParamDeps(params2)

}
\author{
Zhonghui Huang
}
