% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcrPlot.R
\name{mcrPlot}
\alias{mcrPlot}
\title{Misclassification Rate Plot}
\usage{
mcrPlot(nlcvObj, plot = TRUE, optimalDots = TRUE, rescale = FALSE, layout = TRUE, ...)
}
\arguments{
\item{nlcvObj}{Object of class 'nlcv' as produced by the \code{nlcv}
function}

\item{plot}{logical.  If \code{FALSE}, nothing is plotted.}

\item{optimalDots}{Boolean indicating whether dots should be displayed on a
panel below the graph to mark the optimal number of features for a given
classification technique}

\item{rescale}{if \code{TRUE}, the upper limit of y-axis is dependent on the
data (maximum mcr value); defaults to \code{FALSE} which implies limits
\code{c(0,1)}}

\item{layout}{boolean indicating whether \code{mcrPlot} should prespecify a
layout for a single plot (default, \code{TRUE}) or whetherl the user takes
care of the layout (\code{FALSE})}

\item{\dots}{Dots argument to pass additional graphical parameters (such as
\code{main}) to the \code{plot} function}
}
\value{
An MCR plot is output to the device of choice. The dots represent
the mean MCR across runs. The vertical lines below and above the dots
represent the standard deviation of the MCR values across runs.

Below the plot coloured solid dots (one for each classification technique)
indicate for which number of features a given technique reached its minimum
MCR.

The function invisibly returns an object of class \code{mcrPlot} which is a
list with components:
\itemize{
 \item meanMcrMatrix: matrix with for each number of
features (rows) and classification technique (columns) the mean of the MCR
values across all runs of the nlcv procedure.
\item sdMcrMatrix: matrix
with for each number of features (rows) and classification technique
(columns) the sd of the MCR values across all runs of the nlcv procedure.
}
The \code{summary} method for the \code{mcrPlot} object returns a matrix
with for each classification technique, the optimal number of features as
well as the associated mean MCR and standard deviation of the MCR values.
}
\description{
plots for each classification technique and a given number of features used
the mean misclassification rate (mcr) and its standard error across all runs
of the nested loop cross-validation.
}
\seealso{
\code{\link{nlcv}}
}
\author{
Willem Talloen and Tobias Verbeke
}
\keyword{manip}
