% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNestedApprox.R
\name{setParamGrid}
\alias{setParamGrid}
\title{Set the parameter grid for the nested approximation}
\usage{
setParamGrid(summary, quadRule = "NULL", nQuad = -1, prune = -1)
}
\arguments{
\item{summary}{an approxSummary object, returned by \code{runNestedApprox}.}

\item{quadRule}{quadrature rule to use for the parameter grid. Can be any of
\code{"CCD"}, \code{"AGHQ"}, \code{"AGHQSPARSE"}, or \code{"USER"},
the latter to use the user-defined rule provided to \code{buildNestedApprox}.}

\item{nQuad}{number of quadrature points (not used for \code{"CCD"}.}

\item{prune}{pruning parameter for removing AGHQ points at low-density points.}
}
\value{
None. Modifies the summary object in place.
}
\description{
Allows the user to change the parameter grid used in the nested approximation.
}
\details{
If the chosen quadrature rule is \code{"AGHQSPARSE"}, then \code{sampleLatents} will no longer work
as it requires that all the quadrature weights are non-negative, which is no longer true for sparse AGHQ.

To use a user-defined quadrature rule, this needs to be passed to \code{buildNestedApprox}.
}
