% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadratureGrids.R
\name{logSumExp}
\alias{logSumExp}
\title{Log sum exponential.}
\usage{
logSumExp(log1, log2)
}
\arguments{
\item{log1}{scalar of value 1 to exponentiate and sum.}

\item{log2}{scalar of value 2 to exponentiate and sum with value 1.}
}
\value{
\code{logSumExp} returns \code{log(exp(log1) + exp(log2))}
}
\description{
Compute the sum of two log values on the real scale and return on log scale.
}
\details{
Adds two values from the log scale at the exponential scale, and then logs it. When values are really negative,
this function is numerically stable and reduces the chance of underflow. It is a two value version of a log-sum-exponential.
}
