% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztdraw_sc_linear.R
\name{ztdraw_sc_linear}
\alias{ztdraw_sc_linear}
\title{Simulate \code{size} samples from a zero-truncated non homogeneous Poisson Point Process (zt-NHPPP) from
(t_min, t_max) with linear intensity function}
\usage{
ztdraw_sc_linear(intercept, slope, t_min, t_max, atmost1 = FALSE)
}
\arguments{
\item{intercept}{(double) the intercept}

\item{slope}{(double) the slope}

\item{t_min}{(double) the lower bound of the time interval}

\item{t_max}{(double) the upper bound of the time interval}

\item{atmost1}{(boolean) draw 1 event time}
}
\value{
a vector of at least 1 event times
}
\description{
Sample zero-truncated NHPPP times from a linear intensity function
using the inversion method, optionally using an \code{rstream}
generator
}
\examples{
x <- ztdraw_sc_linear(intercept = 0, slope = 0.2, t_min = 0, t_max = 10)

}
