% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_stats.R
\name{calculate_stats}
\alias{calculate_stats}
\title{Calculate NFL Stats}
\usage{
calculate_stats(
  seasons = nflreadr::most_recent_season(),
  summary_level = c("season", "week"),
  stat_type = c("player", "team"),
  season_type = c("REG", "POST", "REG+POST"),
  pbp = NULL
)
}
\arguments{
\item{seasons}{A numeric vector of 4-digit years associated with given NFL
seasons - defaults to latest season. If set to TRUE, returns all available
data since 1999. Ignored if argument \code{pbp} is not \code{NULL}.}

\item{summary_level}{Summarize stats by \code{"season"} or \code{"week"}.}

\item{stat_type}{Calculate \code{"player"} level stats or \code{"team"} level stats.}

\item{season_type}{One of \code{"REG"}, \code{"POST"}, or \code{"REG+POST"}. Filters
data to regular season ("REG"), post season ("POST") or keeps all data.
Only applied if \code{summary_level} == \code{"season"}.}

\item{pbp}{This argument allows passing a subset of nflverse play-by-play
data, created with \code{\link[=build_nflfastR_pbp]{build_nflfastR_pbp()}} or loaded with \code{\link[=load_pbp]{load_pbp()}}.
Stats are then calculated based on the \code{game_id}s and \code{play_id}s in this
subset of play-by-play data, rather then using the seasons specified in the
\code{seasons} argument. The function will error if required variables are
missing from the subset, but lists which variables are missing.
If \code{pbp = NULL} (the default), all available games and plays from the
\code{seasons} argument are used to calculate stats.
Please use this responsibly, because the output is structurally identical
to full seasons, even if plays have been filtered out. It may then appear
as if the stats are incorrect. If \code{pbp} is not \code{NULL}, the function will add
the attribute \code{"custom_pbp" = TRUE} to the function output to help identify
stats that are possibly based on play-by-play subsets.}
}
\value{
A tibble of player/team stats summarized by season/week.
}
\description{
Compute various NFL stats based off nflverse Play-by-Play data.
}
\examples{
\donttest{
try({# to avoid CRAN test problems
stats <- calculate_stats(2023, "season", "player")
dplyr::glimpse(stats)
})
}
}
\seealso{
\link{nfl_stats_variables} for a description of all variables.

\url{https://nflfastr.com/articles/stats_variables.html} for a searchable
table of the stats variable descriptions.
}
