test_that("Data validation works", {
  good_data <- data.frame(
    Auxili_min = 1:3, Auxili_max = 4:6,
    Study_min = 7:9, Study_max = 10:12
  )
  bad_data <- data.frame(Auxili_min = 1:3)

  expect_silent(.check_neutro_data(good_data))
  expect_error(.check_neutro_data(bad_data))
})

test_that("Metric calculations are correct", {
  test_data <- data.frame(
    Auxili_min = c(1, 2, 3),
    Auxili_max = c(4, 5, 6),
    Study_min = c(7, 8, 9),
    Study_max = c(10, 11, 12)
  )

  res <- compute_all_metrics(test_data)

  expect_equal(res$mean_interval_X, c(2, 5))
  expect_length(res$correlation_results, 2)
})
