% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchlight.R
\name{searchlight_shape_functions}
\alias{searchlight_shape_functions}
\alias{ellipsoid_shape}
\alias{cube_shape}
\alias{blobby_shape}
\title{Convenience shape generators for \code{resampled_searchlight()}}
\usage{
ellipsoid_shape(scales = c(1, 1, 1), jitter = 0)

cube_shape()

blobby_shape(drop = 0.3, edge_fraction = 0.7)
}
\arguments{
\item{scales}{Length-3 positive numeric vector scaling the x/y/z axes relative
to a sphere (for \code{ellipsoid_shape}). Values >1 stretch; <1 compress.}

\item{jitter}{Non-negative numeric; standard deviation of multiplicative
Gaussian noise applied to \code{scales} each draw (ellipsoid).}

\item{drop}{Numeric in [0,1]; probability of dropping a voxel (blobby).}

\item{edge_fraction}{Numeric in (0,1]; fraction of farthest voxels (by
Euclidean distance from the center, in voxel units) considered "edge" and
eligible for random dropping (blobby).}
}
\value{
A function suitable for the \code{shape_fun} argument of
  \code{resampled_searchlight()}.
}
\description{
Helpers that return ready-to-use \code{shape_fun} callbacks for
\code{resampled_searchlight()}, covering a few sensible non-spherical
defaults.
}
\details{
Each returned function has signature \code{function(mask, center, radius, iter, nonzero)}
and should return an \eqn{n \times 3} integer coordinate matrix. The
coordinates are later converted to a \code{ROIVolWindow} internally.
}
\examples{
mask <- read_vol(system.file("extdata", "global_mask_v4.nii", package="neuroim2"))

# Ellipsoid stretched along z with modest per-iteration jitter
sl_ellip <- resampled_searchlight(mask, radius = 6,
                                   shape_fun = ellipsoid_shape(scales = c(1, 1, 1.4),
                                                              jitter = 0.1))

# Simple axis-aligned cube (Chebyshev ball)
sl_cube <- resampled_searchlight(mask, radius = 5, shape_fun = "cube")

# Blobby sphere with 40\% dropout on boundary voxels
sl_blob <- resampled_searchlight(mask, radius = 6,
                                 shape_fun = blobby_shape(drop = 0.4, edge_fraction = 0.6))

}
