% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_image.R
\name{read_image}
\alias{read_image}
\title{read_image}
\usage{
read_image(
  file_name,
  type = c("auto", "vol", "vec"),
  index = 1,
  indices = NULL,
  mask = NULL,
  mode = c("normal", "mmap", "bigvec", "filebacked")
)
}
\arguments{
\item{file_name}{Character vector of file paths.}

\item{type}{One of \code{"auto"}, \code{"vol"}, or \code{"vec"} to override dispatch.}

\item{index}{Volume index to use when returning a \code{\linkS4class{NeuroVol}} or
when you want to load a subset of volumes while still returning a \code{NeuroVec}.}

\item{indices}{Optional vector of indices passed through to \code{\link{read_vec}}.}

\item{mask}{Optional mask passed to \code{\link{read_vec}}.}

\item{mode}{IO mode forwarded to \code{\link{read_vec}}.}
}
\value{
A \code{\linkS4class{NeuroVol}} when the input is effectively 3D (or when
  \code{type = "vol"}), otherwise a \code{\linkS4class{NeuroVec}}/\code{\linkS4class{NeuroVecSeq}}.
}
\description{
Convenience wrapper that inspects the file metadata and dispatches to
\code{\link{read_vol}} for 3D data or \code{\link{read_vec}} for 4D data.
}
\examples{
vol <- read_image(system.file("extdata", "global_mask2.nii.gz", package = "neuroim2"))
vec <- read_image(system.file("extdata", "global_mask_v4.nii", package = "neuroim2"))

}
