% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-ortho.R
\name{plot_ortho}
\alias{plot_ortho}
\title{Orthogonal three-plane view with optional crosshairs}
\usage{
plot_ortho(
  vol,
  coord = NULL,
  unit = c("index", "mm"),
  cmap = "grays",
  range = c("robust", "data"),
  probs = c(0.02, 0.98),
  crosshair = TRUE,
  annotate = TRUE,
  downsample = 1L
)
}
\arguments{
\item{vol}{A 3D volume handled by `slice()`.}

\item{coord}{Length-3 coordinate of the target point. Interpreted as voxel
indices by default; set `unit = "mm"` to convert using `coord_to_grid()`
if available in your environment.}

\item{unit}{"index" or "mm".}

\item{cmap}{Palette for the slices.}

\item{range}{"robust" or "data" for intensity limits shared by all panels.}

\item{probs}{Quantiles for robust range.}

\item{crosshair}{Logical; draw crosshair lines.}

\item{annotate}{Logical; add orientation glyphs.}

\item{downsample}{Integer decimation for speed.}
}
\description{
Creates axial, coronal, and sagittal panels at a given coordinate with
harmonized aesthetics. Returns (invisibly) the three ggplot objects after
printing them in a single row using base grid (no extra deps).
}
