% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgb_nuisance.R
\name{make_time_weights}
\alias{make_time_weights}
\title{Build smooth time weights from motion/outlier metrics}
\usage{
make_time_weights(
  fd = NULL,
  dvars = NULL,
  spike = NULL,
  fd_thr = 0.5,
  dvars_z = 2.5,
  spike_z = 5,
  fd_soft = 0.1,
  dvars_soft = 0.25,
  combine = c("min", "prod")
)
}
\arguments{
\item{fd}{Optional numeric vector of framewise displacement values.}

\item{dvars}{Optional numeric vector of DVARS values.}

\item{spike}{Optional numeric vector with spike/outlier magnitudes.}

\item{fd_thr}{Threshold (in mm) where FD weights start to drop (default 0.5).}

\item{dvars_z}{Z-threshold applied to the standardized DVARS series (default 2.5).}

\item{spike_z}{Z-threshold applied to the standardized spike series (default 5).}

\item{fd_soft}{Logistic softness (in mm) controlling the slope around \code{fd_thr}.}

\item{dvars_soft}{Logistic softness for the DVARS z-scores.}

\item{combine}{Either \code{"min"} (take the minimum weight per TR) or
\code{"prod"} (multiply all weights).}
}
\value{
Numeric vector of weights in \eqn{[0,1]} with length equal to the
  provided series. At least one of \code{fd}, \code{dvars}, or \code{spike}
  must be supplied.
}
\description{
Creates per-time-point weights \eqn{w_t \in [0, 1]} by smoothly combining
framewise displacement (FD), DVARS, and spike/outlier scores. Each series is
transformed through a soft logistic ramp so that values beyond the specified
thresholds receive progressively lower weights instead of hard 0/1 decisions.
}
