% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti_extensions.R
\name{get_afni_attribute}
\alias{get_afni_attribute}
\title{Get AFNI Attribute from Extension}
\usage{
get_afni_attribute(ext, attr_name)
}
\arguments{
\item{ext}{A \code{\link{NiftiExtension-class}} object with ecode = 4,
or an xml_document from \code{\link{parse_afni_extension}}.}

\item{attr_name}{Character string specifying the attribute name to retrieve
(e.g., "HISTORY_NOTE", "BRICK_LABS").}
}
\value{
The attribute value, or NULL if not found. The type depends on the
  attribute's ni_type in the XML.
}
\description{
Extracts a specific attribute value from a parsed AFNI extension.
}
\examples{
\dontrun{
# Get the history note from an AFNI extension
history <- get_afni_attribute(afni_ext, "HISTORY_NOTE")
}

}
