% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgb.R
\name{cgb_filter}
\alias{cgb_filter}
\title{Correlation-guided bilateral filtering (convenience wrapper)}
\usage{
cgb_filter(
  runs,
  mask = NULL,
  spatial_sigma = 2,
  window = NULL,
  corr_map = c("power", "exp", "soft"),
  corr_param = 2,
  topk = 16L,
  passes = 1L,
  lambda = 1,
  leave_one_out = FALSE,
  run_weights = NULL,
  add_self = TRUE,
  time_weights = NULL,
  confounds = NULL,
  robust = c("none", "huber", "tukey"),
  robust_c = 1.345,
  return_graph = FALSE
)
}
\arguments{
\item{runs}{A \code{\linkS4class{NeuroVec}} or a list of \code{NeuroVec}.}

\item{mask}{Optional \code{\linkS4class{LogicalNeuroVol}}/\code{NeuroVol} or
logical array for spatial masking. Defaults to in-mask voxels.}

\item{spatial_sigma}{Spatial Gaussian sigma in mm. Used both for weighting
and, when \code{window} is \code{NULL}, to auto-choose the neighborhood size.}

\item{window}{Integer half-width of the cubic neighborhood. If \code{NULL},
it is computed as \code{ceiling(2 * spatial_sigma / min(spacing))} and at
least 1.}

\item{corr_map}{Mapping from pooled correlation to affinity; one of
\code{"power"}, \code{"exp"}, or \code{"soft"}. Defaults to \code{"power"}.}

\item{corr_param}{Parameter for \code{corr_map} (gamma/tau/r0 respectively).}

\item{topk}{Keep strongest \code{k} neighbors (0 keeps all). Defaults to 16.}

\item{passes}{Number of smoothing passes (>=1). Defaults to 1.}

\item{lambda}{Blend factor in [0,1] per pass. Defaults to 1 (pure diffusion).}

\item{leave_one_out}{If \code{TRUE} and multiple runs are supplied, builds
LORO graphs and returns a list of smoothed runs.}

\item{run_weights}{Optional numeric weights per run for Fisher-z pooling.}

\item{add_self}{Logical; add a tiny self-edge before normalization.}

\item{time_weights}{Optional list (or single vector) of per-run time weights.}

\item{confounds}{Optional list (or single matrix) of per-run confounds.}

\item{robust}{One of \code{"none"}, \code{"huber"}, or \code{"tukey"}.}

\item{robust_c}{Tuning constant for robust weights.}

\item{return_graph}{Logical; if \code{TRUE}, also return the graph(s)
alongside the smoothed data.}
}
\value{
If \code{leave_one_out=FALSE}, a smoothed \code{NeuroVec}. If
  \code{leave_one_out=TRUE}, a list of smoothed \code{NeuroVec}. When
  \code{return_graph=TRUE}, returns a list with elements \code{result} and
  \code{graph} (single object or lists accordingly).
}
\description{
High-level interface that builds a correlation-guided bilateral (CGB) graph
with sensible defaults (similar to the bilateral filter interface) and
immediately applies it to smooth the data.
}
\details{
This is a convenience front-end to \code{cgb_make_graph} and
\code{cgb_smooth} with a bilateral-like interface:
- If \code{window} is \code{NULL}, it is chosen as
  \code{ceiling(2 * spatial_sigma / min(spacing))} (at least 1). Larger
  windows allow correlations over more distant neighbors, at the cost of
  extra compute and memory.
- \code{spatial_sigma} (in mm) controls how quickly spatial weights fall
  with distance. Small values emphasize very local structure; larger values
  mix information over a wider spatial footprint.
- \code{corr_map} and \code{corr_param} set how pooled correlations are
  turned into edge weights:
  * \code{"power"}: \code{a(r) = r^gamma} for \code{r > 0}. Larger
    \code{gamma} (e.g., 3-4) strongly emphasizes high correlations and
    produces more edge-preserving, patchy smoothing; smaller values (e.g., 1-2)
    behave more like standard correlation-weighted smoothing.
  * \code{"exp"}: Gaussian on \code{1 - r} with scale \code{tau}. Small
    \code{tau} keeps only very similar time-series; larger \code{tau} makes
    the filter closer to a spatial Gaussian while still respecting sign.
  * \code{"soft"}: \code{a(r) = max(r - r0, 0)}. Increasing \code{r0}
    discards more weak correlations and tends to sharpen edges but can make
    the result more piecewise-constant.
- \code{topk} limits each voxel to at most \code{k} strongest neighbors.
  Smaller \code{topk} yields sparser, more anisotropic graphs (cheaper but
  sometimes less smooth); larger \code{topk} increases mixing and memory.
- \code{passes} and \code{lambda} control diffusion strength. With
  \code{lambda = 1}, each pass applies pure graph diffusion; multiple passes
  compound smoothing. Choosing \code{lambda < 1} blends each pass with the
  identity and can prevent over-smoothing when using more passes.
- Setting \code{leave_one_out = TRUE} for multi-run inputs builds a separate
  graph for each run that excludes its own correlations, which reduces
  information leakage in cross-validation or decoding workflows.
- \code{time_weights}, \code{confounds}, and \code{robust}/\code{robust_c}
  adjust how time-points contribute to the correlation estimates. Down-
  weighting high-motion/high-DVARS frames (via \code{make_time_weights} and
  \code{robust != "none"}) will typically yield smoother, less noisy graphs
  but can also reduce effective temporal degrees of freedom.
- Use \code{return_graph = TRUE} when you plan to reuse the constructed
  graph(s) with \code{cgb_smooth} or inspect their sparsity pattern.
}
\examples{
\donttest{
vec <- read_vec(system.file("extdata", "global_mask_v4.nii", package = "neuroim2"))
mask <- read_vol(system.file("extdata", "global_mask_v4.nii", package = "neuroim2"))

# Auto window from spatial_sigma and spacing, single pass
out <- cgb_filter(vec, mask, spatial_sigma = 3, window = NULL, topk = 16)

# Stronger diffusion with two passes and lambda < 1
out2 <- cgb_filter(vec, mask, spatial_sigma = 4, window = NULL,
                   passes = 2, lambda = 0.7)
}

}
