% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R, R/nifti_extensions.R
\docType{class}
\name{NiftiExtension-class}
\alias{NiftiExtension-class}
\alias{show,NiftiExtension-method}
\title{NiftiExtension Class}
\usage{
\S4method{show}{NiftiExtension}(object)
}
\arguments{
\item{object}{A \code{\linkS4class{NiftiExtension}} object.}
}
\description{
Represents a single NIfTI header extension block. NIfTI extensions allow
additional metadata to be stored with the image file.
}
\details{
NIfTI-1.1 extensions follow this structure:
\itemize{
  \item Bytes 0-3: esize (int32) - total extension size, must be multiple of 16
  \item Bytes 4-7: ecode (int32) - extension code identifying format
  \item Bytes 8-(esize-1): edata - the actual extension data
}

Extensions are chained sequentially after the NIfTI header (byte 352) until
the vox_offset is reached.
}
\section{Slots}{

\describe{
\item{\code{ecode}}{An \code{integer} extension code identifying the type of extension.
See \code{\link{NiftiExtensionCodes}} for known codes.}

\item{\code{esize}}{An \code{integer} giving the total size of the extension in bytes,
including the 8-byte header (esize + ecode). Must be a multiple of 16.}

\item{\code{edata}}{A \code{raw} vector containing the extension data (length = esize - 8).}
}}

\examples{
# Create a simple comment extension
comment_text <- "This is a test comment"
ext <- NiftiExtension(ecode = 6L, data = comment_text)

# Access the extension code
ext@ecode

}
\seealso{
\code{\link{NiftiExtensionCodes}} for registered extension codes.
\code{\link{NiftiExtensionList-class}} for a collection of extensions.
\code{\link{parse_extension}} for parsing extension data.
}
